/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.StringEditorTable;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.utils.CommonUtils;

public class EditObjectFilterDialog
extends HelpEnabledDialog {
    public static final int SHOW_GLOBAL_FILTERS_ID = 1000;
    private static final String NULL_FILTER_NAME = "";
    private final DBPDataSourceRegistry dsRegistry;
    private String objectTitle;
    private DBSObjectFilter filter;
    private boolean globalFilter;
    private Composite blockControl;
    private ControlEnableState blockEnableState;
    private Table includeTable;
    private Table excludeTable;
    private Combo namesCombo;
    private Button enableButton;

    public EditObjectFilterDialog(Shell shell, DBPDataSourceRegistry dsRegistry, String objectTitle, DBSObjectFilter filter, boolean globalFilter) {
        super(shell, "object-filters");
        this.dsRegistry = dsRegistry;
        this.objectTitle = objectTitle;
        this.filter = new DBSObjectFilter(filter);
        this.globalFilter = globalFilter;
    }

    public DBSObjectFilter getFilter() {
        return this.filter;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(NLS.bind((String)CoreMessages.dialog_filter_title, (Object)this.objectTitle));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite topPanel = UIUtils.createPlaceholder((Composite)composite, (int)(this.globalFilter ? 1 : 2));
        topPanel.setLayoutData((Object)new GridData(768));
        this.enableButton = UIUtils.createCheckbox((Composite)topPanel, (String)CoreMessages.dialog_filter_button_enable, (boolean)false);
        this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.filter.setEnabled(EditObjectFilterDialog.this.enableButton.getSelection());
                EditObjectFilterDialog.this.enableFiltersContent();
            }
        });
        this.enableButton.setLayoutData((Object)new GridData(768));
        this.enableButton.setSelection(this.filter.isEnabled());
        if (!this.globalFilter) {
            Link globalLink = UIUtils.createLink((Composite)topPanel, (String)CoreMessages.dialog_filter_global_link, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditObjectFilterDialog.this.setReturnCode(1000);
                    EditObjectFilterDialog.this.close();
                }
            });
            globalLink.setLayoutData((Object)new GridData(128));
        }
        this.blockControl = UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.blockControl.setLayoutData((Object)new GridData(1808));
        this.includeTable = StringEditorTable.createEditableList(this.blockControl, CoreMessages.dialog_filter_list_include, this.filter.getInclude(), null, null);
        this.excludeTable = StringEditorTable.createEditableList(this.blockControl, CoreMessages.dialog_filter_list_exclude, this.filter.getExclude(), null, null);
        UIUtils.createInfoLabel((Composite)this.blockControl, (String)CoreMessages.dialog_connection_edit_wizard_general_filter_hint_text);
        Group sfGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.dialog_connection_edit_wizard_general_filter_save_label, (int)4, (int)768, (int)0);
        this.namesCombo = UIUtils.createLabelCombo((Composite)sfGroup, (String)CoreMessages.dialog_connection_edit_wizard_general_filter_name_label, (int)4);
        this.namesCombo.setLayoutData((Object)new GridData(768));
        this.namesCombo.add(NULL_FILTER_NAME);
        ArrayList<String> sfNames = new ArrayList<String>();
        for (DBSObjectFilter sf : this.dsRegistry.getSavedFilters()) {
            sfNames.add(sf.getName());
        }
        Collections.sort(sfNames);
        for (String sfName : sfNames) {
            this.namesCombo.add(sfName);
        }
        this.namesCombo.setText(CommonUtils.notEmpty((String)this.filter.getName()));
        this.namesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.changeSavedFilter();
            }
        });
        Button saveButton = UIUtils.createPushButton((Composite)sfGroup, (String)CoreMessages.dialog_connection_edit_wizard_general_filter_save_button, null);
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.saveConfigurations();
            }
        });
        Button removeButton = UIUtils.createPushButton((Composite)sfGroup, (String)CoreMessages.dialog_connection_edit_wizard_general_filter_remove_button, null);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditObjectFilterDialog.this.dsRegistry.removeSavedFilter(EditObjectFilterDialog.this.namesCombo.getText());
                EditObjectFilterDialog.this.namesCombo.setText(EditObjectFilterDialog.NULL_FILTER_NAME);
            }
        });
        this.enableFiltersContent();
        return composite;
    }

    private void changeSavedFilter() {
        String filterName = this.namesCombo.getText();
        if (CommonUtils.equalObjects((Object)filterName, (Object)this.filter.getName())) {
            return;
        }
        if (CommonUtils.isEmpty((String)filterName)) {
            StringEditorTable.fillFilterValues(this.includeTable, null, null);
            StringEditorTable.fillFilterValues(this.excludeTable, null, null);
        } else {
            DBSObjectFilter savedFilter = this.dsRegistry.getSavedFilter(filterName);
            if (savedFilter != null) {
                StringEditorTable.fillFilterValues(this.includeTable, savedFilter.getInclude(), null);
                StringEditorTable.fillFilterValues(this.excludeTable, savedFilter.getExclude(), null);
            }
        }
        this.filter.setName(filterName);
    }

    private void enableFiltersContent() {
        if (this.filter.isEnabled()) {
            if (this.blockEnableState != null) {
                this.blockEnableState.restore();
                this.blockEnableState = null;
            }
        } else if (this.blockEnableState == null) {
            this.blockEnableState = ControlEnableState.disable((Control)this.blockControl);
        }
    }

    private void saveConfigurations() {
        this.filter.setEnabled(this.enableButton.getSelection());
        this.filter.setInclude(StringEditorTable.collectValues(this.includeTable));
        this.filter.setExclude(StringEditorTable.collectValues(this.excludeTable));
        this.filter.setName(this.namesCombo.getText());
        if (!CommonUtils.isEmpty((String)this.filter.getName())) {
            this.dsRegistry.updateSavedFilter(this.filter);
        }
    }

    protected void okPressed() {
        this.saveConfigurations();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

