/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.MultiPageWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;

public class EditConnectionDialog
extends MultiPageWizardDialog {
    public static final int TEST_BUTTON_ID = 2000;
    private Button testButton;

    public EditConnectionDialog(IWorkbenchWindow window, ConnectionWizard wizard) {
        super(window, (IWizard)wizard);
    }

    public ConnectionWizard getWizard() {
        return (ConnectionWizard)super.getWizard();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)"DBeaver.EditConnectionDialog");
    }

    @Override
    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        DataSourceDescriptor activeDataSource = this.getWizard().getActiveDataSource();
        this.getShell().setText(NLS.bind((String)CoreMessages.dialog_connection_edit_title, (Object)activeDataSource.getName()));
        this.getShell().setImage(DBeaverIcons.getImage((DBPImage)activeDataSource.getObjectImage()));
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.testButton = this.createButton(parent, 2000, CoreMessages.dialog_connection_button_test, false);
        this.testButton.setEnabled(false);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (buttonId == 2000) {
            this.testConnection();
            return;
        }
        super.buttonPressed(buttonId);
    }

    @Override
    public void updateButtons() {
        if (this.testButton != null) {
            ConnectionPageSettings settings = this.getWizard().getPageSettings();
            this.testButton.setEnabled(settings != null && settings.isPageComplete());
        }
        super.updateButtons();
    }

    private void testConnection() {
        this.getWizard().testConnection();
    }
}

