/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPropertiesControl;
import org.jkiss.utils.CommonUtils;

public class DriverPropertiesDialogPage
extends ConnectionPageAbstract {
    private ConnectionPageAbstract hostPage;
    private ConnectionPropertiesControl propsControl;
    private PropertySourceCustom propertySource;
    private DBPConnectionConfiguration prevConnectionInfo = null;

    public DriverPropertiesDialogPage(ConnectionPageAbstract hostPage) {
        this.hostPage = hostPage;
        this.setTitle(CoreMessages.dialog_setting_connection_driver_properties_title);
        this.setDescription(CoreMessages.dialog_setting_connection_driver_properties_description);
    }

    public boolean isComplete() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.propsControl != null) {
            DBPDataSourceContainer activeDataSource = this.site.getActiveDataSource();
            if (this.prevConnectionInfo == activeDataSource.getConnectionConfiguration()) {
                return;
            }
            final DBPConnectionConfiguration tmpConnectionInfo = new DBPConnectionConfiguration();
            DataSourceDescriptor tempDataSource = new DataSourceDescriptor(this.site.getDataSourceRegistry(), activeDataSource.getId(), (DriverDescriptor)activeDataSource.getDriver(), tmpConnectionInfo);
            this.hostPage.saveSettings(tempDataSource);
            tmpConnectionInfo.getProperties().putAll(activeDataSource.getConnectionConfiguration().getProperties());
            try {
                this.getSite().getRunnableContext().run(true, true, new DBRRunnableWithProgress(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Loading driver properties", 1);
                        try {
                            DriverPropertiesDialogPage.this.propertySource = DriverPropertiesDialogPage.this.propsControl.makeProperties(monitor, DriverPropertiesDialogPage.this.site.getDriver(), tmpConnectionInfo);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(e.getTargetException().getMessage());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.propertySource != null) {
                this.propsControl.loadProperties(this.propertySource);
            }
            this.prevConnectionInfo = activeDataSource.getConnectionConfiguration();
            tempDataSource.dispose();
        }
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        if (this.propertySource != null) {
            Map properties = dataSource.getConnectionConfiguration().getProperties();
            properties.clear();
            for (Map.Entry<Object, Object> entry : this.propertySource.getProperties().entrySet()) {
                properties.put(CommonUtils.toString((Object)entry.getKey()), CommonUtils.toString((Object)entry.getValue()));
            }
        }
    }

    public void createControl(Composite parent) {
        this.propsControl = new ConnectionPropertiesControl(parent, 0);
        this.setControl(this.propsControl.getControl());
    }
}

