/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.connection.DBPClientHome;
import org.jkiss.dbeaver.model.connection.DBPClientManager;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesPanel;

public class ClientHomesSelector {
    private static final Log log = Log.getLog(ClientHomesSelector.class);
    private Composite selectorPanel;
    private Combo homesCombo;
    private DBPDriver driver;
    private List<String> homeIds = new ArrayList<String>();
    private String currentHomeId;

    public ClientHomesSelector(Composite parent, int style, String title) {
        this.selectorPanel = new Composite(parent, style);
        this.selectorPanel.setLayout((Layout)new GridLayout(2, false));
        UIUtils.createControlLabel((Composite)this.selectorPanel, (String)title);
        this.homesCombo = new Combo(this.selectorPanel, 8);
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.homesCombo.setLayoutData((Object)gd);
        this.homesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ClientHomesSelector.this.homesCombo.getSelectionIndex() == ClientHomesSelector.this.homesCombo.getItemCount() - 1) {
                    ClientHomesSelector.this.manageHomes();
                } else {
                    ClientHomesSelector.this.currentHomeId = (String)ClientHomesSelector.this.homeIds.get(ClientHomesSelector.this.homesCombo.getSelectionIndex());
                }
                ClientHomesSelector.this.displayClientVersion();
                ClientHomesSelector.this.handleHomeChange();
            }
        });
    }

    public Composite getPanel() {
        return this.selectorPanel;
    }

    private void manageHomes() {
        String newHomeId = ClientHomesPanel.chooseClientHome(this.selectorPanel.getShell(), this.driver);
        if (newHomeId != null) {
            this.currentHomeId = newHomeId;
        }
        this.populateHomes(this.driver, this.currentHomeId);
    }

    public void populateHomes(DBPDriver driver, String currentHome) {
        this.driver = driver;
        this.currentHomeId = currentHome;
        this.homesCombo.removeAll();
        this.homeIds.clear();
        DBPClientManager clientManager = driver.getClientManager();
        if (clientManager != null) {
            LinkedHashSet homes = new LinkedHashSet(clientManager.findClientHomeIds());
            homes.addAll(driver.getClientHomeIds());
            for (String homeId : homes) {
                DBPClientHome home = driver.getClientHome(homeId);
                if (home == null) continue;
                this.homesCombo.add(home.getDisplayName());
                this.homeIds.add(home.getHomeId());
                if (this.currentHomeId == null || !home.getHomeId().equals(this.currentHomeId)) continue;
                this.homesCombo.select(this.homesCombo.getItemCount() - 1);
            }
            this.homesCombo.add(CoreMessages.controls_client_home_selector_browse);
        }
        this.displayClientVersion();
    }

    private void displayClientVersion() {
    }

    protected void handleHomeChange() {
    }

    public String getSelectedHome() {
        return this.currentHomeId;
    }
}

