/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ISearchContextProvider;
import org.jkiss.dbeaver.ui.ISearchExecutor;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.controls.itemlist.DatabaseObjectListControl;
import org.jkiss.dbeaver.ui.controls.itemlist.ObjectListControl;
import org.jkiss.dbeaver.ui.dialogs.AbstractPopupPanel;
import org.jkiss.utils.CommonUtils;

public class SelectObjectDialog<T extends DBPObject>
extends AbstractPopupPanel {
    private static final String DIALOG_ID = "DBeaver.SelectObjectDialog";
    private String listId;
    private Collection<T> objects;
    private List<T> selectedObjects = new ArrayList<T>();
    private boolean singleSelection;
    private Font boldFont;

    public SelectObjectDialog(Shell parentShell, String title, boolean singleSelection, String listId, Collection<T> objects, Collection<T> selected) {
        super(parentShell, title);
        this.singleSelection = singleSelection;
        this.listId = listId;
        this.objects = new ArrayList<T>(objects);
        if (selected != null) {
            this.selectedObjects.addAll(selected);
        }
        this.boldFont = UIUtils.makeBoldFont((Font)parentShell.getFont());
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)("DBeaver.SelectObjectDialog." + this.listId));
    }

    protected Control createDialogArea(Composite parent) {
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        DatabaseObjectListControl objectList = new DatabaseObjectListControl<T>(group, this.singleSelection ? 4 : 2, null, (IContentProvider)new ListContentProvider()){
            private ISearchExecutor searcher;
            {
                this.searcher = new ObjectListControl.SearcherFilter(this);
            }

            @Override
            @NotNull
            protected String getListConfigId(List<Class<?>> classList) {
                return SelectObjectDialog.this.listId;
            }

            @Override
            protected LoadingJob<Collection<T>> createLoadService() {
                return LoadingJob.createService(new AbstractLoadService<Collection<T>>(){

                    public Collection<T> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        return SelectObjectDialog.this.objects;
                    }

                    public Object getFamily() {
                        return SelectObjectDialog.this;
                    }
                }, new ObjectListControl.ObjectsLoadVisualizer(this){

                    @Override
                    public void completeLoading(Collection<T> items) {
                        super.completeLoading(items);
                        this.performSearch(ISearchContextProvider.SearchType.NONE);
                        this.getItemsViewer().getControl().setFocus();
                        SelectObjectDialog.this.closeOnFocusLost(new Control[]{this.getItemsViewer().getControl(), this.getSearchTextControl()});
                    }
                });
            }

            @Override
            protected CellLabelProvider getColumnLabelProvider(ObjectListControl.ObjectColumn objectColumn) {
                return new ObjectLabelProvider(objectColumn);
            }

            @Override
            protected Object getObjectValue(T item) {
                if (item instanceof DBSWrapper) {
                    return ((DBSWrapper)item).getObject();
                }
                return super.getObjectValue(item);
            }

            @Override
            protected DBPImage getObjectImage(T item) {
                if (item instanceof DBNDatabaseNode) {
                    return ((DBNDatabaseNode)item).getNodeIcon();
                }
                return null;
            }

            @Override
            protected void setListData(Collection<T> items, boolean append) {
                super.setListData(items, append);
                if (SelectObjectDialog.this.selectedObjects != null) {
                    this.getItemsViewer().setSelection((ISelection)new StructuredSelection(SelectObjectDialog.this.selectedObjects), true);
                }
            }

            @Override
            protected void fillCustomActions(IContributionManager contributionManager) {
                super.fillCustomActions(contributionManager);
                this.addColumnConfigAction(contributionManager);
            }

            @Override
            protected void addSearchAction(IContributionManager contributionManager) {
                contributionManager.add((IAction)new Action("Filter objects", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SEARCH)){

                    public void run() {
                        this.performSearch(ISearchContextProvider.SearchType.NONE);
                    }
                });
            }

            @Override
            protected ISearchExecutor getSearchRunner() {
                return this.searcher;
            }

            class ObjectLabelProvider
            extends ObjectListControl.ObjectColumnLabelProvider
            implements IFontProvider {
                ObjectLabelProvider(ObjectListControl.ObjectColumn objectColumn) {
                    super(this, objectColumn);
                }

                public Font getFont(Object element) {
                    if (SelectObjectDialog.this.selectedObjects.contains(element)) {
                        return SelectObjectDialog.this.boldFont;
                    }
                    return null;
                }
            }
        };
        objectList.createProgressPanel();
        gd = new GridData(1808);
        gd.heightHint = 300;
        gd.minimumWidth = 300;
        objectList.setLayoutData(gd);
        objectList.getSelectionProvider().addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            this.selectedObjects.clear();
            this.selectedObjects.addAll(selection.toList());
            if (!this.isModeless()) {
                this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
            }
        });
        objectList.setDoubleClickHandler(event -> {
            if (this.isModeless() || this.getButton(0).isEnabled()) {
                this.okPressed();
            }
        });
        objectList.loadData();
        return group;
    }

    public int open() {
        int result = super.open();
        UIUtils.dispose((Resource)this.boldFont);
        return result;
    }

    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        if (!this.isModeless()) {
            this.getButton(0).setEnabled(false);
        }
        return ctl;
    }

    public List<T> getSelectedObjects() {
        return this.selectedObjects;
    }

    public T getSelectedObject() {
        return (T)(this.selectedObjects.isEmpty() ? null : (DBPObject)this.selectedObjects.get(0));
    }

    public static <T extends DBPObject> T selectObject(Shell parentShell, String title, String listId, Collection<T> objects) {
        SelectObjectDialog<T> scDialog = new SelectObjectDialog<T>(parentShell, title, true, listId, objects, null);
        if (scDialog.open() == 0) {
            List<T> selectedObjects = scDialog.getSelectedObjects();
            return (T)(CommonUtils.isEmpty(selectedObjects) ? null : (DBPObject)selectedObjects.get(0));
        }
        return null;
    }
}

