/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.impl.ExternalContentStorage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DialogUtils {
    private static final Log log = Log.getLog(DialogUtils.class);
    private static final String DIALOG_FOLDER_PROPERTY = "dialog.default.folder";
    public static String curDialogFolder = DBeaverCore.getGlobalPreferenceStore().getString("dialog.default.folder");

    static {
        if (CommonUtils.isEmpty((String)curDialogFolder)) {
            curDialogFolder = RuntimeUtils.getUserHomeDir().getAbsolutePath();
        }
    }

    public static File selectFileForSave(Shell parentShell, String valueName) {
        return DialogUtils.selectFileForSave(parentShell, "Save Content As", null, valueName);
    }

    public static File selectFileForSave(Shell parentShell, String title, String[] filterExt, @Nullable String fileName) {
        FileDialog fileDialog = new FileDialog(parentShell, 8192);
        fileDialog.setText(title);
        fileDialog.setOverwrite(true);
        if (filterExt != null) {
            fileDialog.setFilterExtensions(filterExt);
        }
        if (fileName != null) {
            fileDialog.setFileName(fileName);
        }
        if (CommonUtils.isEmpty((String)(fileName = DialogUtils.openFileDialog(fileDialog)))) {
            return null;
        }
        File saveFile = new File(fileName);
        File saveDir = saveFile.getParentFile();
        if (!saveDir.exists()) {
            DBUserInterface.getInstance().showError("Bad file name", "Directory '" + saveDir.getAbsolutePath() + "' does not exists");
            return null;
        }
        return saveFile;
    }

    public static File openFile(Shell parentShell) {
        return DialogUtils.openFile(parentShell, null);
    }

    public static File openFile(Shell parentShell, String[] filterExt) {
        String fileName;
        FileDialog fileDialog = new FileDialog(parentShell, 4096);
        if (filterExt != null) {
            fileDialog.setFilterExtensions(filterExt);
        }
        if (CommonUtils.isEmpty((String)(fileName = DialogUtils.openFileDialog(fileDialog)))) {
            return null;
        }
        File loadFile = new File(fileName);
        if (!loadFile.exists()) {
            MessageBox aMessageBox = new MessageBox(parentShell, 40);
            aMessageBox.setText("File doesn't exists");
            aMessageBox.setMessage("The file " + loadFile.getAbsolutePath() + " doesn't exists.");
            aMessageBox.open();
            return null;
        }
        return loadFile;
    }

    public static String openFileDialog(FileDialog fileDialog) {
        String fileName;
        if (curDialogFolder != null) {
            fileDialog.setFilterPath(curDialogFolder);
        }
        if (!CommonUtils.isEmpty((String)(fileName = fileDialog.open()))) {
            DialogUtils.setCurDialogFolder(fileDialog.getFilterPath());
        }
        return fileName;
    }

    public static boolean loadFromFile(final IValueController controller) {
        if (!(controller.getValue() instanceof DBDContent)) {
            log.error((Object)(String.valueOf(CoreMessages.model_jdbc_bad_content_value_) + controller.getValue()));
            return false;
        }
        Shell shell = UIUtils.getShell((IShellProvider)controller.getValueSite());
        final File openFile = DialogUtils.openFile(shell);
        if (openFile == null) {
            return false;
        }
        final DBDContent value = (DBDContent)controller.getValue();
        UIUtils.runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

            public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ExternalContentStorage storage = ContentUtils.isTextContent((DBDContent)value) ? new ExternalContentStorage((DBPPlatform)DBeaverCore.getInstance(), openFile, "UTF-8") : new ExternalContentStorage((DBPPlatform)DBeaverCore.getInstance(), openFile);
                    value.updateContents(monitor, (DBDContentStorage)storage);
                    controller.updateValue(value, true);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        return true;
    }

    public static void saveToFile(IValueController controller) {
        if (!(controller.getValue() instanceof DBDContent)) {
            log.error((Object)(String.valueOf(CoreMessages.model_jdbc_bad_content_value_) + controller.getValue()));
            return;
        }
        Shell shell = UIUtils.getShell((IShellProvider)controller.getValueSite());
        final File saveFile = DialogUtils.selectFileForSave(shell, controller.getValueName());
        if (saveFile == null) {
            return;
        }
        final DBDContent value = (DBDContent)controller.getValue();
        try {
            UIUtils.runInProgressService((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block21: {
                        try {
                            DBDContentStorage storage = value.getContents(monitor);
                            if (ContentUtils.isTextContent((DBDContent)value)) {
                                Throwable throwable = null;
                                Object var4_8 = null;
                                try (Reader cr = storage.getContentReader();){
                                    ContentUtils.saveContentToFile((Reader)cr, (File)saveFile, (String)"UTF-8", (DBRProgressMonitor)monitor);
                                    break block21;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            Throwable throwable = null;
                            Object var4_10 = null;
                            try (InputStream cs = storage.getContentStream();){
                                ContentUtils.saveContentToFile((InputStream)cs, (File)saveFile, (DBRProgressMonitor)monitor);
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            DBUserInterface.getInstance().showError(CoreMessages.model_jdbc_could_not_save_content, String.valueOf(CoreMessages.model_jdbc_could_not_save_content_to_file_) + saveFile.getAbsolutePath() + "'", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getCurDialogFolder() {
        return curDialogFolder;
    }

    public static void setCurDialogFolder(String curDialogFolder) {
        DBeaverCore.getGlobalPreferenceStore().setValue(DIALOG_FOLDER_PROPERTY, curDialogFolder);
        DialogUtils.curDialogFolder = curDialogFolder;
    }

    @NotNull
    public static Text createOutputFolderChooser(final Composite parent, @Nullable String label, @Nullable ModifyListener changeListener) {
        final String message = label != null ? label : CoreMessages.data_transfer_wizard_output_label_directory;
        UIUtils.createControlLabel((Composite)parent, (String)message);
        TextWithOpen directoryText = new TextWithOpen(parent){

            @Override
            protected void openBrowser() {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 0);
                dialog.setMessage("Choose target directory");
                dialog.setText(message);
                String directory = this.getText();
                if (CommonUtils.isEmpty((String)directory)) {
                    directory = curDialogFolder;
                }
                if (!CommonUtils.isEmpty((String)directory)) {
                    dialog.setFilterPath(directory);
                }
                if ((directory = dialog.open()) != null) {
                    this.setText(directory);
                    DialogUtils.setCurDialogFolder(directory);
                }
            }
        };
        directoryText.setLayoutData(new GridData(768));
        if (changeListener != null) {
            directoryText.getTextControl().addModifyListener(changeListener);
        }
        return directoryText.getTextControl();
    }
}

