/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.DateTimeInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.DateTimeStandaloneEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;

public class DateTimeValueManager
extends BaseValueManager {
    protected static final Log log = Log.getLog(DateTimeValueManager.class);

    @Override
    public void contributeActions(@NotNull IContributionManager manager, final @NotNull IValueController controller, @Nullable IValueEditor activeEditor) throws DBCException {
        super.contributeActions(manager, controller, activeEditor);
        manager.add((IAction)new Action(CoreMessages.model_jdbc_set_to_current_time, DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_DATETIME)){

            public boolean isEnabled() {
                return !controller.isReadOnly();
            }

            public void run() {
                controller.updateValue(new Date(), true);
            }
        });
    }

    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.INLINE, IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: 
            case PANEL: {
                return new DateTimeInlineEditor(controller);
            }
            case EDITOR: {
                return new DateTimeStandaloneEditor(controller);
            }
        }
        return null;
    }
}

