/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.managers;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.preferences.DBPPropertyManager;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueEditor;
import org.jkiss.dbeaver.ui.data.editors.ContentInlineEditor;
import org.jkiss.dbeaver.ui.data.editors.ContentPanelEditor;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.data.managers.BaseValueManager;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.dialogs.data.TextViewDialog;
import org.jkiss.dbeaver.ui.editors.content.ContentEditor;
import org.jkiss.dbeaver.utils.ContentUtils;

public class ContentValueManager
extends BaseValueManager {
    private static final Log log = Log.getLog(ContentValueManager.class);
    public static final String PROP_CATEGORY_CONTENT = "CONTENT";

    public static void contributeContentActions(@NotNull IContributionManager manager, final @NotNull IValueController controller, final IValueEditor activeEditor) throws DBCException {
        if (controller.getValue() instanceof DBDContent && !((DBDContent)controller.getValue()).isNull()) {
            manager.add((IAction)new Action(CoreMessages.model_jdbc_save_to_file_, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SAVE_AS)){

                public void run() {
                    DialogUtils.saveToFile(controller);
                }
            });
        }
        manager.add((IAction)new Action(CoreMessages.model_jdbc_load_from_file_, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.LOAD)){

            public void run() {
                if (DialogUtils.loadFromFile(controller) && activeEditor != null) {
                    try {
                        activeEditor.primeEditorValue(controller.getValue());
                    }
                    catch (DBException e) {
                        DBUserInterface.getInstance().showError("Load from file", "Error loading contents from file", (Throwable)e);
                    }
                }
            }
        });
        manager.add((IContributionItem)new Separator());
    }

    public static IValueEditor openContentEditor(@NotNull IValueController controller) {
        Object value = controller.getValue();
        IValueController.EditType binaryEditType = IValueController.EditType.valueOf(controller.getExecutionContext().getDataSource().getContainer().getPreferenceStore().getString("resultset.binary.editor"));
        if (controller.getValueType().getDataKind() == DBPDataKind.STRING) {
            return new TextViewDialog(controller);
        }
        if (binaryEditType != IValueController.EditType.EDITOR && value instanceof DBDContentCached) {
            return new TextViewDialog(controller);
        }
        if (value instanceof DBDContent) {
            return ContentEditor.openEditor(controller);
        }
        controller.showMessage(CoreMessages.model_jdbc_unsupported_content_value_type_, DBPMessageType.ERROR);
        return null;
    }

    @Override
    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller, @Nullable IValueEditor activeEditor) throws DBCException {
        super.contributeActions(manager, controller, activeEditor);
        ContentValueManager.contributeContentActions(manager, controller, activeEditor);
    }

    @Override
    public void contributeProperties(@NotNull DBPPropertyManager propertySource, @NotNull IValueController controller) {
        super.contributeProperties(propertySource, controller);
        try {
            Object value = controller.getValue();
            if (value instanceof DBDContent) {
                propertySource.addProperty(PROP_CATEGORY_CONTENT, (Object)"content_type", CoreMessages.model_jdbc_content_type, (Object)((DBDContent)value).getContentType());
                long contentLength = ((DBDContent)value).getContentLength();
                if (contentLength >= 0L) {
                    propertySource.addProperty(PROP_CATEGORY_CONTENT, (Object)"content_length", CoreMessages.model_jdbc_content_length, (Object)contentLength);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can't extract CONTENT value information", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public IValueController.EditType[] getSupportedEditTypes() {
        return new IValueController.EditType[]{IValueController.EditType.PANEL, IValueController.EditType.EDITOR};
    }

    @Override
    public IValueEditor createEditor(@NotNull IValueController controller) throws DBException {
        switch (controller.getEditType()) {
            case INLINE: {
                Object value = controller.getValue();
                if (controller.getValueType().getDataKind() == DBPDataKind.STRING) {
                    return new StringInlineEditor(controller);
                }
                if (value instanceof DBDContentCached && ContentUtils.isTextValue((Object)((DBDContentCached)value).getCachedValue())) {
                    return new ContentInlineEditor(controller);
                }
                return null;
            }
            case EDITOR: {
                return ContentValueManager.openContentEditor(controller);
            }
            case PANEL: {
                return new ContentPanelEditor(controller);
            }
        }
        return null;
    }
}

