/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueMeta;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.utils.CommonUtils;

public class ResultSetDataContainer
implements DBSDataContainer,
IAdaptable {
    private static final Log log = Log.getLog(ResultSetDataContainer.class);
    private final DBSDataContainer dataContainer;
    private final ResultSetModel model;
    private ResultSetDataContainerOptions options;

    public ResultSetDataContainer(DBSDataContainer dataContainer, ResultSetModel model, ResultSetDataContainerOptions options) {
        this.dataContainer = dataContainer;
        this.model = model;
        this.options = options;
    }

    public String getDescription() {
        return this.dataContainer.getDescription();
    }

    public DBSObject getParentObject() {
        return this.dataContainer.getParentObject();
    }

    public DBPDataSource getDataSource() {
        return this.dataContainer.getDataSource();
    }

    public int getSupportedFeatures() {
        return 1;
    }

    public ResultSetDataContainerOptions getOptions() {
        return this.options;
    }

    public DBCStatistics readData(DBCExecutionSource source, DBCSession session, DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags) throws DBCException {
        if (this.proceedSelectedRowsOnly() || this.proceedSelectedColumnsOnly()) {
            long startTime = System.currentTimeMillis();
            DBCStatistics statistics = new DBCStatistics();
            statistics.setExecuteTime(System.currentTimeMillis() - startTime);
            ModelResultSet resultSet = new ModelResultSet(session);
            long resultCount = 0L;
            try {
                dataReceiver.fetchStart(session, (DBCResultSet)resultSet, firstRow, maxRows);
                while (resultSet.nextRow()) {
                    if (!this.proceedSelectedRowsOnly() || this.options.getSelectedRows().contains(resultCount)) {
                        dataReceiver.fetchRow(session, (DBCResultSet)resultSet);
                    }
                    ++resultCount;
                }
            }
            finally {
                try {
                    dataReceiver.fetchEnd(session, (DBCResultSet)resultSet);
                }
                catch (DBCException e) {
                    log.error((Object)"Error while finishing result set fetch", (Throwable)e);
                }
                resultSet.close();
                dataReceiver.close();
            }
            statistics.setFetchTime(System.currentTimeMillis() - startTime);
            statistics.setRowsFetched(resultCount);
            return statistics;
        }
        return this.dataContainer.readData(source, session, dataReceiver, dataFilter, firstRow, maxRows, flags);
    }

    private boolean proceedSelectedColumnsOnly() {
        return this.options.isExportSelectedColumns() && !CommonUtils.isEmpty(this.options.getSelectedColumns());
    }

    private boolean proceedSelectedRowsOnly() {
        return this.options.isExportSelectedRows() && !CommonUtils.isEmpty(this.options.getSelectedRows());
    }

    public long countData(DBCExecutionSource source, DBCSession session, DBDDataFilter dataFilter) throws DBCException {
        if (this.proceedSelectedRowsOnly()) {
            return this.options.getSelectedRows().size();
        }
        if (this.proceedSelectedColumnsOnly()) {
            return this.model.getRowCount();
        }
        return this.dataContainer.countData(source, session, dataFilter);
    }

    public String getName() {
        return this.dataContainer.getName();
    }

    public boolean isPersisted() {
        return this.dataContainer.isPersisted();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.dataContainer)) {
            return adapter.cast(this.dataContainer);
        }
        return null;
    }

    private class ModelResultSet
    implements DBCResultSet {
        private final DBCSession session;
        private ResultSetRow curRow;

        ModelResultSet(DBCSession session) {
            this.session = session;
        }

        public DBCSession getSession() {
            return this.session;
        }

        public DBCStatement getSourceStatement() {
            return null;
        }

        public Object getAttributeValue(int index) throws DBCException {
            return ResultSetDataContainer.this.model.getCellValue(ResultSetDataContainer.this.model.getVisibleAttribute(index), this.curRow);
        }

        public Object getAttributeValue(String name) throws DBCException {
            DBDAttributeBinding attr = (DBDAttributeBinding)DBUtils.findObject(ResultSetDataContainer.this.model.getVisibleAttributes(), (String)name);
            if (attr == null) {
                throw new DBCException("Attribute '" + name + "' not found");
            }
            return ResultSetDataContainer.this.model.getCellValue(attr, this.curRow);
        }

        public DBDValueMeta getAttributeValueMeta(int index) throws DBCException {
            return null;
        }

        public DBDValueMeta getRowMeta() throws DBCException {
            return null;
        }

        public boolean nextRow() throws DBCException {
            if (this.curRow == null) {
                if (ResultSetDataContainer.this.model.getRowCount() == 0) {
                    return false;
                }
                this.curRow = ResultSetDataContainer.this.model.getRow(0);
            } else {
                if (this.curRow.getRowNumber() >= ResultSetDataContainer.this.model.getRowCount() - 1) {
                    return false;
                }
                this.curRow = ResultSetDataContainer.this.model.getRow(this.curRow.getRowNumber() + 1);
            }
            return true;
        }

        public boolean moveTo(int position) throws DBCException {
            if (position >= ResultSetDataContainer.this.model.getRowCount() - 1) {
                return false;
            }
            this.curRow = ResultSetDataContainer.this.model.getRow(position);
            return true;
        }

        public DBCResultSetMetaData getMeta() throws DBCException {
            return () -> {
                List<DBDAttributeBinding> attributes = ResultSetDataContainer.this.model.getVisibleAttributes();
                ArrayList<DBCAttributeMetaData> meta = new ArrayList<DBCAttributeMetaData>(attributes.size());
                boolean selectedColumnsOnly = ResultSetDataContainer.this.proceedSelectedColumnsOnly();
                for (DBDAttributeBinding attribute : attributes) {
                    DBCAttributeMetaData metaAttribute = attribute.getMetaAttribute();
                    if (selectedColumnsOnly && !ResultSetDataContainer.this.options.getSelectedColumns().contains(metaAttribute.getName())) continue;
                    meta.add(metaAttribute);
                }
                return meta;
            };
        }

        public String getResultSetName() throws DBCException {
            return "ClientResults";
        }

        public void close() {
        }
    }
}

