/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.lightgrid.AbstractRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

class GridColumnRenderer
extends AbstractRenderer {
    public static final int LEFT_MARGIN = 6;
    public static final int RIGHT_MARGIN = 6;
    public static final int BOTTOM_MARGIN = 6;
    public static final int TOP_MARGIN = 6;
    public static final int ARROW_MARGIN = 6;
    public static final int IMAGE_SPACING = 3;
    public static final Image IMAGE_ASTERISK = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_UNKNOWN);
    public static final Image IMAGE_DESC = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_DECREASE);
    public static final Image IMAGE_ASC = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_INCREASE);
    public static final Image IMAGE_FILTER = DBeaverIcons.getImage((DBPImage)UIIcon.FILTER_SMALL);
    public static final int SORT_WIDTH = GridColumnRenderer.IMAGE_DESC.getBounds().width;
    public static final int FILTER_WIDTH = GridColumnRenderer.IMAGE_FILTER.getBounds().width;

    public GridColumnRenderer(LightGrid grid) {
        super(grid);
    }

    public static Rectangle getSortControlBounds() {
        return IMAGE_DESC.getBounds();
    }

    public static Rectangle getFilterControlBounds() {
        return IMAGE_FILTER.getBounds();
    }

    @Nullable
    protected Image getColumnImage(Object element) {
        return this.grid.getLabelProvider().getImage(element);
    }

    protected String getColumnText(Object element) {
        return this.grid.getLabelProvider().getText(element);
    }

    protected String getColumnDescription(Object element) {
        return this.grid.getLabelProvider().getDescription(element);
    }

    protected Font getColumnFont(Object element) {
        Font font = this.grid.getLabelProvider().getFont(element);
        return font != null ? font : this.grid.normalFont;
    }

    public void paint(GC gc, Rectangle bounds, boolean selected, boolean hovering, Object element) {
        boolean hasFilters = this.grid.getContentProvider().isElementSupportsFilter(element);
        int sortOrder = this.grid.getContentProvider().getSortOrder(element);
        Rectangle sortBounds = GridColumnRenderer.getSortControlBounds();
        Rectangle filterBounds = GridColumnRenderer.getFilterControlBounds();
        gc.setFont(this.getColumnFont(element));
        boolean flat = true;
        boolean drawSelected = false;
        if (flat && (selected || hovering)) {
            gc.setBackground(this.grid.getContentProvider().getCellHeaderSelectionBackground());
        } else {
            gc.setBackground(this.grid.getContentProvider().getCellHeaderBackground());
        }
        gc.setForeground(this.grid.getContentProvider().getCellHeaderForeground());
        gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        int pushedDrawingOffset = 0;
        if (drawSelected) {
            pushedDrawingOffset = 1;
        }
        int x = 6;
        Image columnImage = this.getColumnImage(element);
        if (columnImage != null) {
            int y = bounds.y + pushedDrawingOffset + 6;
            gc.drawImage(columnImage, bounds.x + x + pushedDrawingOffset, y);
            x += columnImage.getBounds().width + 3;
        }
        int width = bounds.width - x;
        width = sortOrder == 0 ? (width -= 6) : (width -= 6 + sortBounds.width);
        if (hasFilters) {
            width -= filterBounds.width;
        }
        int y = bounds.y + 6;
        String text = this.getColumnText(element);
        text = TextUtils.getShortString(this.grid.fontMetrics, text, width);
        gc.setFont(this.grid.normalFont);
        gc.drawString(text, bounds.x + x + pushedDrawingOffset, y + pushedDrawingOffset, true);
        if (sortOrder != 0) {
            if (drawSelected) {
                sortBounds.x = bounds.x + bounds.width - 6 - sortBounds.width + 1;
                sortBounds.y = y;
            } else {
                sortBounds.x = bounds.x + bounds.width - 6 - sortBounds.width;
                sortBounds.y = y;
            }
            sortBounds.x += 3;
            GridColumnRenderer.paintSort(gc, sortBounds, sortOrder);
        }
        if (hasFilters) {
            gc.drawImage(IMAGE_FILTER, bounds.x + bounds.width - filterBounds.width - (sortOrder != 0 ? 3 + sortBounds.width + 1 : 6), y);
        }
        if (!CommonUtils.isEmpty((String)(text = this.getColumnDescription(element)))) {
            text = TextUtils.getShortString(this.grid.fontMetrics, text, width);
            gc.setFont(this.grid.normalFont);
            gc.drawString(text, bounds.x + x + pushedDrawingOffset, (y += 6 + this.grid.fontMetrics.getHeight()) + pushedDrawingOffset, true);
        }
        if (!flat) {
            if (drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(20));
            }
            gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
            if (!drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(19));
                gc.drawLine(bounds.x + 1, bounds.y + 1, bounds.x + bounds.width - 2, bounds.y + 1);
                gc.drawLine(bounds.x + 1, bounds.y + 1, bounds.x + 1, bounds.y + bounds.height - 2);
            }
            if (drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            }
            gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
            gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
            if (!drawSelected) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
                gc.drawLine(bounds.x + bounds.width - 2, bounds.y + 1, bounds.x + bounds.width - 2, bounds.y + bounds.height - 2);
                gc.drawLine(bounds.x + 1, bounds.y + bounds.height - 2, bounds.x + bounds.width - 2, bounds.y + bounds.height - 2);
            }
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(17));
            gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
            gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        }
        gc.setFont(this.grid.normalFont);
    }

    public static void paintSort(GC gc, Rectangle bounds, int sort) {
        switch (sort) {
            case -1: {
                gc.drawImage(IMAGE_ASTERISK, bounds.x, bounds.y);
                break;
            }
            case 128: {
                gc.drawImage(IMAGE_ASC, bounds.x, bounds.y);
                break;
            }
            case 1024: {
                gc.drawImage(IMAGE_DESC, bounds.x, bounds.y);
            }
        }
    }
}

