/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.navigator;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPOrderedObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBEObjectReorderer;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.editor.EntityEditorsRegistry;
import org.jkiss.dbeaver.runtime.TasksJob;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.actions.navigator.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class NavigatorHandlerObjectMove
extends NavigatorHandlerObjectBase {
    private static final Log log = Log.getLog(NavigatorHandlerObjectMove.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode node = NavigatorUtils.getSelectedNode(selection);
        if (node == null || !(node.getParentNode() instanceof DBNContainer)) {
            return null;
        }
        DBNContainer containerNode = (DBNContainer)node.getParentNode();
        DBSObject object = ((DBNDatabaseNode)node).getObject();
        if (!(object instanceof DBPOrderedObject)) {
            return null;
        }
        DBEObjectReorderer objectReorderer = EntityEditorsRegistry.getInstance().getObjectManager(object.getClass(), DBEObjectReorderer.class);
        if (objectReorderer == null) {
            return null;
        }
        DBPOrderedObject orderedObject = (DBPOrderedObject)object;
        try {
            String actionId;
            ArrayList<DBSObject> siblingObjects = new ArrayList<DBSObject>();
            DBNNode[] dBNNodeArray = node.getParentNode().getChildren((DBRProgressMonitor)new VoidProgressMonitor());
            int n = dBNNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode siblingNode = dBNNodeArray[n2];
                if (siblingNode instanceof DBNDatabaseNode) {
                    DBSObject siblingObject = ((DBNDatabaseNode)siblingNode).getObject();
                    if (siblingObject.getClass() != object.getClass()) {
                        log.warn((Object)("Sibling object class " + siblingObject.getClass() + " differs from moving object class " + object.getClass().getName()));
                    } else {
                        siblingObjects.add(siblingObject);
                    }
                } else {
                    log.warn((Object)("Wrong sibling node type: " + siblingNode));
                }
                ++n2;
            }
            NavigatorHandlerObjectBase.CommandTarget commandTarget = NavigatorHandlerObjectMove.getCommandTarget(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), containerNode, object.getClass(), false);
            switch (actionId = event.getCommand().getId()) {
                case "org.jkiss.dbeaver.core.object.move.up": {
                    objectReorderer.setObjectOrdinalPosition(commandTarget.getContext(), object, siblingObjects, orderedObject.getOrdinalPosition() - 1);
                    break;
                }
                case "org.jkiss.dbeaver.core.object.move.down": {
                    objectReorderer.setObjectOrdinalPosition(commandTarget.getContext(), object, siblingObjects, orderedObject.getOrdinalPosition() + 1);
                }
            }
            if (object.isPersisted() && commandTarget.getEditor() == null) {
                Map options = DBPScriptObject.EMPTY_OPTIONS;
                if (!NavigatorHandlerObjectMove.showScript(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), commandTarget.getContext(), options, "Reorder script")) {
                    commandTarget.getContext().resetChanges();
                    return false;
                }
                NavigatorHandlerObjectBase.ObjectSaver orderer = new NavigatorHandlerObjectBase.ObjectSaver(commandTarget.getContext(), options);
                TasksJob.runTask("Change object '" + object.getName() + "' position", orderer);
            }
        }
        catch (DBException e) {
            DBUserInterface.getInstance().showError("Object move", "Error during object reposition", (Throwable)e);
        }
        return null;
    }
}

