/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.common;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;

public class ToggleViewAction
extends Action
implements IPartListener {
    private String viewId;
    private boolean listenerRegistered = false;
    private IViewDescriptor viewDescriptor;

    public ToggleViewAction(String viewId) {
        this.viewId = viewId;
        this.viewDescriptor = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
    }

    public String getText() {
        if (this.viewDescriptor != null) {
            return this.viewDescriptor.getLabel();
        }
        return super.getText();
    }

    public String getToolTipText() {
        if (this.viewDescriptor != null) {
            return this.viewDescriptor.getDescription();
        }
        return super.getToolTipText();
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.viewDescriptor != null) {
            return this.viewDescriptor.getImageDescriptor();
        }
        return super.getImageDescriptor();
    }

    public int getStyle() {
        return 2;
    }

    public boolean isChecked() {
        if (!this.listenerRegistered) {
            IWorkbenchPage activePage = ToggleViewAction.getActivePage();
            if (activePage == null) {
                return false;
            }
            activePage.addPartListener((IPartListener)this);
            this.listenerRegistered = true;
            IViewReference viewReference = activePage.findViewReference(this.viewId);
            this.setChecked(viewReference != null && viewReference.getView(false) != null);
        }
        return super.isChecked();
    }

    public void run() {
        IWorkbenchPage activePage = ToggleViewAction.getActivePage();
        if (activePage == null) {
            return;
        }
        try {
            IViewPart view = activePage.findView(this.viewId);
            if (view == null) {
                activePage.showView(this.viewId);
            } else {
                activePage.hideView(view);
            }
        }
        catch (PartInitException ex) {
            DBUserInterface.getInstance().showError(this.viewId, "Can't open view " + this.viewId, (Throwable)ex);
        }
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow.getActivePage();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part.getSite().getId().equals(this.viewId)) {
            this.setChecked(true);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.getSite().getId().equals(this.viewId)) {
            this.setChecked(false);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }
}

