/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.jkiss.utils.CommonUtils;

public class TextUtils {
    public static final char PARAGRAPH_CHAR = '\u00b6';

    public static String compactWhiteSpaces(String str) {
        return str.replaceAll("\\s+", " ");
    }

    public static boolean isEmptyLine(IDocument document, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        if (region == null || region.getLength() == 0) {
            return true;
        }
        String str = document.get(region.getOffset(), region.getLength());
        return str.trim().length() == 0;
    }

    public static int getOffsetOf(IDocument document, int line, String pattern) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        if (region == null || region.getLength() == 0) {
            return -1;
        }
        String str = document.get(region.getOffset(), region.getLength());
        return str.indexOf(pattern);
    }

    public static String getShortText(GC gc, String t, int width) {
        int pivot;
        if (CommonUtils.isEmpty((String)t)) {
            return t;
        }
        if (width >= gc.textExtent((String)t).x) {
            return t;
        }
        int w = gc.textExtent((String)"...").x;
        String text = t;
        int l = text.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = text.substring(0, s);
            String s2 = text.substring(e, l);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                text = String.valueOf(s1) + " ... " + s2;
                break;
            }
            --s;
            ++e;
        }
        if (s == 0 || e == l) {
            text = String.valueOf(text.substring(0, 1)) + "..." + text.substring(l - 1, l);
        }
        return text;
    }

    public static String getShortString(FontMetrics fontMetrics, String t, int width) {
        if (CommonUtils.isEmpty((String)t)) {
            return t;
        }
        if (width <= 0) {
            return "";
        }
        int avgCharWidth = fontMetrics.getAverageCharWidth();
        float length = t.length();
        if ((float)width < length * (float)avgCharWidth) {
            length = (float)width / (float)avgCharWidth;
            if ((length = (float)((double)length * 1.5)) < (float)t.length()) {
                t = t.substring(0, (int)length);
            }
        }
        return t;
    }

    public static String formatSentence(String sent) {
        if (sent == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sent, " \t\n\r-,.\\/", true);
        while (st.hasMoreTokens()) {
            String word = st.nextToken();
            if (word.length() <= 0) continue;
            result.append(TextUtils.formatWord(word));
        }
        return result.toString();
    }

    public static String formatWord(String word) {
        if (word == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(word.length());
        sb.append(Character.toUpperCase(word.charAt(0)));
        int i = 1;
        while (i < word.length()) {
            char c = word.charAt(i);
            if ((c == 'i' || c == 'I') && sb.charAt(i - 1) == 'I') {
                sb.append('I');
            } else {
                sb.append(Character.toLowerCase(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public static Point getTextSize(String text) {
        int length = text.length();
        int maxLength = 0;
        int lineCount = 1;
        int lineLength = 0;
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    maxLength = Math.max(maxLength, lineLength);
                    ++lineCount;
                    lineLength = 0;
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    lineLength += 4;
                    break;
                }
                default: {
                    ++lineLength;
                }
            }
            ++i;
        }
        maxLength = Math.max(maxLength, lineLength);
        return new Point(maxLength, lineCount);
    }

    public static boolean isPointInRectangle(int x, int y, int rectX, int rectY, int rectWidth, int rectHeight) {
        return x >= rectX && y >= rectY && x < rectX + rectWidth && y < rectY + rectHeight;
    }

    public static String getSingleLineString(String displayString) {
        return displayString.replace('\n', '\u00b6').replace("\r", "").replace('\u0000', ' ');
    }

    public static int fuzzyScore(CharSequence term, CharSequence query) {
        return TextUtils.fuzzyScore(term, query, Locale.getDefault());
    }

    public static int fuzzyScore(CharSequence term, CharSequence query, Locale locale) {
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        String termLowerCase = term.toString().toLowerCase(locale);
        String queryLowerCase = query.toString().toLowerCase(locale);
        int score = 0;
        int termIndex = 0;
        int previousMatchingCharacterIndex = Integer.MIN_VALUE;
        int queryIndex = 0;
        while (queryIndex < queryLowerCase.length()) {
            char queryChar = queryLowerCase.charAt(queryIndex);
            boolean termCharacterMatchFound = false;
            while (termIndex < termLowerCase.length()) {
                char termChar = termLowerCase.charAt(termIndex);
                if (queryChar == termChar) {
                    ++score;
                    if (termIndex == 0) {
                        score += 4;
                    } else if (!Character.isLetter(termLowerCase.charAt(termIndex - 1))) {
                        score += 2;
                    }
                    if (previousMatchingCharacterIndex + 1 == termIndex) {
                        score += 4;
                    }
                    previousMatchingCharacterIndex = termIndex++;
                    termCharacterMatchFound = true;
                    break;
                }
                ++termIndex;
            }
            if (!termCharacterMatchFound) {
                return 0;
            }
            ++queryIndex;
        }
        return score;
    }

    public static String cutExtraLines(String message, int maxLines) {
        if (message == null || message.indexOf(10) == -1) {
            return message;
        }
        int lfCount = 0;
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < message.length()) {
            char c = message.charAt(i);
            if (c == '\n') {
                ++lfCount;
            }
            buf.append(c);
            if (lfCount == maxLines) {
                buf.append("...");
                break;
            }
            ++i;
        }
        return buf.toString();
    }
}

