/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.transfer.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.registry.transfer.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.registry.transfer.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.utils.CommonUtils;

class DataTransferPagePipes
extends ActiveWizardPage<DataTransferWizard> {
    private TableViewer consumersTable;

    DataTransferPagePipes() {
        super(CoreMessages.data_transfer_wizard_init_name);
        this.setTitle(CoreMessages.data_transfer_wizard_init_title);
        this.setDescription(CoreMessages.data_transfer_wizard_init_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.consumersTable = new TableViewer(composite, 67588);
        this.consumersTable.getTable().setLayoutData((Object)new GridData(1808));
        this.consumersTable.getTable().setLinesVisible(true);
        this.consumersTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }
        });
        CellLabelProvider labelProvider = new CellLabelProvider(){

            public void update(ViewerCell cell) {
                TransferTarget element = (TransferTarget)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    if (element.processor != null) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.processor.getIcon()));
                        cell.setText(element.processor.getName());
                    } else {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)element.consumer.getIcon()));
                        cell.setText(element.consumer.getName());
                    }
                } else if (element.processor != null) {
                    cell.setText(element.processor.getDescription());
                } else {
                    cell.setText(element.consumer.getDescription());
                }
            }
        };
        TableViewerColumn columnName = new TableViewerColumn(this.consumersTable, 16384);
        columnName.setLabelProvider(labelProvider);
        columnName.getColumn().setText(CoreMessages.data_transfer_wizard_init_column_exported);
        TableViewerColumn columnDesc = new TableViewerColumn(this.consumersTable, 16384);
        columnDesc.setLabelProvider(labelProvider);
        columnDesc.getColumn().setText(CoreMessages.data_transfer_wizard_init_column_description);
        this.loadConsumers();
        this.consumersTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DataTransferPagePipes.this.consumersTable.getSelection();
                TransferTarget target = !selection.isEmpty() ? (TransferTarget)selection.getFirstElement() : null;
                if (target == null) {
                    ((DataTransferWizard)((Object)DataTransferPagePipes.this.getWizard())).getSettings().selectConsumer(null, null);
                } else {
                    ((DataTransferWizard)((Object)DataTransferPagePipes.this.getWizard())).getSettings().selectConsumer(target.consumer, target.processor);
                }
                DataTransferPagePipes.this.updatePageCompletion();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (DataTransferPagePipes.this.isPageComplete()) {
                    ((DataTransferWizard)((Object)DataTransferPagePipes.this.getWizard())).getContainer().showPage(((DataTransferWizard)((Object)DataTransferPagePipes.this.getWizard())).getNextPage((IWizardPage)DataTransferPagePipes.this));
                }
            }
        });
        this.consumersTable.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                UIUtils.packColumns((Table)DataTransferPagePipes.this.consumersTable.getTable());
                UIUtils.maxTableColumnsWidth((Table)DataTransferPagePipes.this.consumersTable.getTable());
                DataTransferPagePipes.this.consumersTable.getTable().removeControlListener((ControlListener)this);
            }
        });
        this.setControl((Control)composite);
        DataTransferNodeDescriptor consumer = ((DataTransferWizard)((Object)this.getWizard())).getSettings().getConsumer();
        DataTransferProcessorDescriptor processor = ((DataTransferWizard)((Object)this.getWizard())).getSettings().getProcessor();
        if (consumer != null) {
            Collection targets = (Collection)this.consumersTable.getInput();
            for (TransferTarget target : targets) {
                if (target.consumer != consumer || target.processor != processor) continue;
                this.consumersTable.setSelection((ISelection)new StructuredSelection((Object)target));
                break;
            }
        }
        this.updatePageCompletion();
    }

    private void loadConsumers() {
        DataTransferSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getSettings();
        Collection<DBSObject> objects = settings.getSourceObjects();
        ArrayList<TransferTarget> transferTargets = new ArrayList<TransferTarget>();
        for (DataTransferNodeDescriptor consumer : DataTransferRegistry.getInstance().getAvailableConsumers(objects)) {
            Collection<DataTransferProcessorDescriptor> processors = consumer.getAvailableProcessors(objects);
            if (CommonUtils.isEmpty(processors)) {
                transferTargets.add(new TransferTarget(consumer, null));
                continue;
            }
            for (DataTransferProcessorDescriptor processor : processors) {
                transferTargets.add(new TransferTarget(consumer, processor));
            }
        }
        this.consumersTable.setInput(transferTargets);
    }

    @Override
    protected boolean determinePageCompletion() {
        return ((DataTransferWizard)((Object)this.getWizard())).getSettings().getConsumer() != null;
    }

    private static class TransferTarget {
        DataTransferNodeDescriptor consumer;
        DataTransferProcessorDescriptor processor;

        private TransferTarget(DataTransferNodeDescriptor consumer, DataTransferProcessorDescriptor processor) {
            this.consumer = consumer;
            this.processor = processor;
        }
    }
}

