/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.registry.transfer.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;

class DataTransferPageFinal
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(DataTransferPageFinal.class);
    private Table resultTable;
    private boolean activated = false;

    DataTransferPageFinal() {
        super(CoreMessages.data_transfer_wizard_final_name);
        this.setTitle(CoreMessages.data_transfer_wizard_final_title);
        this.setDescription(CoreMessages.data_transfer_wizard_final_description);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Group tablesGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.data_transfer_wizard_final_group_tables, (int)3, (int)1808, (int)0);
        this.resultTable = new Table((Composite)tablesGroup, 67588);
        this.resultTable.setLayoutData((Object)new GridData(1808));
        this.resultTable.setHeaderVisible(true);
        this.resultTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.resultTable, (int)16384, (String)CoreMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.resultTable, (int)16384, (String)CoreMessages.data_transfer_wizard_final_column_target);
        UIUtils.packColumns((Table)this.resultTable);
        this.setControl((Control)composite);
    }

    @Override
    public void activatePage() {
        this.resultTable.removeAll();
        DataTransferSettings settings = ((DataTransferWizard)((Object)this.getWizard())).getSettings();
        List<DataTransferPipe> dataPipes = settings.getDataPipes();
        for (DataTransferPipe pipe : dataPipes) {
            IDataTransferSettings consumerSettings = settings.getNodeSettings(pipe.getConsumer());
            DataTransferProcessorDescriptor processorDescriptor = settings.getProcessor();
            IDataTransferProcessor processor = null;
            if (processorDescriptor != null) {
                try {
                    processor = processorDescriptor.getInstance();
                }
                catch (Throwable e) {
                    log.error((Object)"Can't create processor", e);
                    continue;
                }
            }
            pipe.getConsumer().initTransfer(pipe.getProducer().getSourceObject(), consumerSettings, processorDescriptor != null && processorDescriptor.isBinaryFormat(), processor, processor == null ? null : settings.getProcessorProperties());
            TableItem item = new TableItem(this.resultTable, 0);
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)pipe.getProducer().getSourceObject(), (DBPEvaluationContext)DBPEvaluationContext.UI));
            if (settings.getProducer() != null && settings.getProducer().getIcon() != null) {
                item.setImage(0, DBeaverIcons.getImage((DBPImage)settings.getProducer().getIcon()));
            }
            item.setText(1, pipe.getConsumer().getTargetName());
            if (processorDescriptor != null && processorDescriptor.getIcon() != null) {
                item.setImage(1, DBeaverIcons.getImage((DBPImage)processorDescriptor.getIcon()));
                continue;
            }
            if (settings.getConsumer() == null || settings.getConsumer().getIcon() == null) continue;
            item.setImage(1, DBeaverIcons.getImage((DBPImage)settings.getConsumer().getIcon()));
        }
        this.activated = true;
        UIUtils.packColumns((Table)this.resultTable, (boolean)true);
        this.updatePageCompletion();
    }

    public boolean isActivated() {
        return this.activated;
    }

    @Override
    protected boolean determinePageCompletion() {
        return this.activated;
    }
}

