/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.impl.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterJSON
extends StreamExporterAbstract {
    public static final String PROP_FORMAT_DATE_ISO = "formatDateISO";
    public static final String PROP_PRINT_TABLE_NAME = "printTableName";
    private PrintWriter out;
    private List<DBDAttributeBinding> columns;
    private String tableName;
    private int rowNum = 0;
    private boolean printTableName = true;
    private boolean formatDateISO = true;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.out = site.getWriter();
        this.formatDateISO = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_FORMAT_DATE_ISO), (boolean)true);
        this.printTableName = CommonUtils.getBoolean((Object)site.getProperties().get(PROP_PRINT_TABLE_NAME), (boolean)true);
    }

    @Override
    public void dispose() {
        this.out = null;
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.tableName = this.getSite().getSource().getName();
        this.printHeader();
    }

    private void printHeader() {
        if (this.printTableName) {
            this.out.write("{\n");
            this.out.write("\"" + JSONUtils.escapeJsonString((String)this.tableName) + "\": ");
        }
        this.out.write("[\n");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, Object[] row) throws DBException, IOException {
        if (this.rowNum > 0) {
            this.out.write(",\n");
        }
        ++this.rowNum;
        this.out.write("\t{\n");
        i = 0;
        while (i < row.length) {
            column = this.columns.get(i);
            columnName = column.getLabel();
            if (CommonUtils.isEmpty((String)columnName)) {
                columnName = column.getName();
            }
            this.out.write("\t\t\"" + JSONUtils.escapeJsonString((String)columnName) + "\" : ");
            cellValue = row[i];
            if (DBUtils.isNullValue((Object)cellValue)) {
                this.writeTextCell(null);
            } else if (cellValue instanceof DBDContent) {
                content = (DBDContent)cellValue;
                try {
                    cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) ** GOTO lbl54
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        var9_9 = null;
                        var10_11 = null;
                        try {
                            in = cs.getContentReader();
                            try {
                                this.out.write("\"");
                                this.writeCellValue(in);
                                this.out.write("\"");
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                        }
                        catch (Throwable var10_12) {
                            if (var9_9 == null) {
                                var9_9 = var10_12;
                            } else if (var9_9 != var10_12) {
                                var9_9.addSuppressed(var10_12);
                            }
                            throw var9_9;
                        }
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    content.release();
                }
            } else if (cellValue instanceof Number || cellValue instanceof Boolean) {
                this.out.write(cellValue.toString());
            } else if (cellValue instanceof Date && this.formatDateISO) {
                this.writeTextCell(JSONUtils.formatDate((Date)((Date)cellValue)));
            } else {
                this.writeTextCell(super.getValueDisplayString(column, cellValue));
            }
lbl54:
            // 7 sources

            if (i < row.length - 1) {
                this.out.write(",");
            }
            this.out.write("\n");
            ++i;
        }
        this.out.write("\t}");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws IOException {
        this.out.write("\n]");
        if (this.printTableName) {
            this.out.write("}");
        }
        this.out.write("\n");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            this.out.write("\"" + JSONUtils.escapeJsonString((String)value) + "\"");
        } else {
            this.out.write("null");
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            this.out.write(JSONUtils.escapeJsonString((String)new String(buffer, 0, count)));
        }
    }
}

