/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.utils.CommonUtils;

class DatabaseMappingAttribute
implements DatabaseMappingObject {
    public static final String TARGET_NAME_SKIP = "[skip]";
    final DatabaseMappingContainer parent;
    DBSAttributeBase source;
    DBSEntityAttribute target;
    String targetName;
    String targetType;
    DatabaseMappingType mappingType;

    DatabaseMappingAttribute(DatabaseMappingContainer parent, DBSAttributeBase source) {
        this.parent = parent;
        this.source = source;
        this.mappingType = DatabaseMappingType.unspecified;
    }

    public DatabaseMappingContainer getParent() {
        return this.parent;
    }

    @Override
    public DBPImage getIcon() {
        return DBValueFormatting.getObjectImage((DBPObject)this.source);
    }

    public DBSAttributeBase getSource() {
        return this.source;
    }

    public String getSourceType() {
        String typeName = this.source.getTypeName();
        if (this.source.getDataKind() == DBPDataKind.STRING) {
            typeName = String.valueOf(typeName) + "(" + this.source.getMaxLength() + ")";
        }
        return typeName;
    }

    @Override
    public String getTargetName() {
        switch (this.mappingType) {
            case existing: {
                if (this.target != null) {
                    return DBUtils.getObjectFullName((DBPNamedObject)this.target, (DBPEvaluationContext)DBPEvaluationContext.UI);
                }
                return this.targetName;
            }
            case create: {
                return this.targetName;
            }
            case skip: {
                return TARGET_NAME_SKIP;
            }
        }
        return "?";
    }

    @Override
    public DatabaseMappingType getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(DatabaseMappingType mappingType) {
        this.mappingType = mappingType;
        switch (mappingType) {
            case create: {
                this.targetName = this.getSource().getName();
            }
        }
    }

    void updateMappingType(DBRProgressMonitor monitor) throws DBException {
        DBSObjectContainer container;
        switch (this.parent.getMappingType()) {
            case existing: {
                this.mappingType = DatabaseMappingType.unspecified;
                if (!(this.parent.getTarget() instanceof DBSEntity)) break;
                if (CommonUtils.isEmpty((String)this.targetName)) {
                    this.targetName = this.source.getName();
                }
                this.target = (DBSEntityAttribute)DBUtils.findObject((Collection)((DBSEntity)this.parent.getTarget()).getAttributes(monitor), (String)this.targetName);
                if (this.target != null) {
                    this.mappingType = DatabaseMappingType.existing;
                    break;
                }
                this.mappingType = DatabaseMappingType.create;
                break;
            }
            case create: {
                this.mappingType = DatabaseMappingType.create;
                if (!CommonUtils.isEmpty((String)this.targetName)) break;
                this.targetName = this.source.getName();
                break;
            }
            case skip: {
                this.mappingType = DatabaseMappingType.skip;
                break;
            }
            default: {
                this.mappingType = DatabaseMappingType.unspecified;
            }
        }
        if (this.mappingType == DatabaseMappingType.create && !CommonUtils.isEmpty((String)this.targetName) && (container = this.parent.getSettings().getContainer()) != null) {
            this.targetName = DBObjectNameCaseTransformer.transformName((DBPDataSource)container.getDataSource(), (String)this.targetName);
        }
    }

    public DBSEntityAttribute getTarget() {
        return this.target;
    }

    public void setTarget(DBSEntityAttribute target) {
        this.target = target;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetType(DBPDataSource targetDataSource) {
        String modifiers;
        if (!CommonUtils.isEmpty((String)this.targetType)) {
            return this.targetType;
        }
        String typeName = this.source.getTypeName();
        DBPDataKind dataKind = this.source.getDataKind();
        if (targetDataSource instanceof DBPDataTypeProvider) {
            DBPDataTypeProvider dataTypeProvider = (DBPDataTypeProvider)targetDataSource;
            DBSDataType dataType = dataTypeProvider.getLocalDataType(typeName);
            if (dataType == null && typeName.equals("DOUBLE") && (dataType = dataTypeProvider.getLocalDataType("DOUBLE PRECISION")) != null) {
                typeName = dataType.getTypeName();
            }
            if (dataType != null && dataType.getDataKind() != dataKind) {
                dataType = null;
            }
            if (dataType == null) {
                ArrayList<DBSDataType> possibleTypes = new ArrayList<DBSDataType>();
                for (DBSDataType type : dataTypeProvider.getLocalDataTypes()) {
                    if (type.getDataKind() != dataKind) continue;
                    possibleTypes.add(type);
                }
                DBSDataType targetType = null;
                if (!possibleTypes.isEmpty()) {
                    for (DBSDataType type : possibleTypes) {
                        if (!type.getName().contains(typeName) && !typeName.contains(type.getName())) continue;
                        targetType = type;
                        break;
                    }
                }
                if (targetType == null) {
                    typeName = DBUtils.getDefaultDataTypeName((DBPDataSource)targetDataSource, (DBPDataKind)dataKind);
                    if (!possibleTypes.isEmpty()) {
                        for (DBSDataType type : possibleTypes) {
                            if (!type.getName().equalsIgnoreCase(typeName)) continue;
                            targetType = type;
                            break;
                        }
                    }
                }
                if (targetType == null && !possibleTypes.isEmpty()) {
                    targetType = (DBSDataType)possibleTypes.get(0);
                }
                if (targetType != null) {
                    typeName = targetType.getTypeName();
                }
            }
            if (dataType != null) {
                dataKind = dataType.getDataKind();
            }
        }
        if ((modifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)this.parent.getSettings().getTargetDataSource(this), (DBSTypedObject)this.source, (String)typeName, (DBPDataKind)dataKind)) != null) {
            typeName = String.valueOf(typeName) + modifiers;
        }
        return typeName;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }
}

