/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import org.eclipse.swt.program.Program;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class WebUtils {
    private static final Log log = Log.getLog(WebUtils.class);
    private static final int MAX_RETRY_COUNT = 10;

    @NotNull
    public static URLConnection openConnection(String urlString) throws IOException {
        return WebUtils.openConnection(urlString, null);
    }

    @NotNull
    public static URLConnection openConnection(String urlString, DBAAuthInfo authInfo) throws IOException {
        return WebUtils.openURLConnection(urlString, authInfo, 1);
    }

    @NotNull
    private static URLConnection openURLConnection(String urlString, DBAAuthInfo authInfo, int retryNumber) throws IOException {
        int responseCode;
        HttpURLConnection httpConnection;
        if (retryNumber > 10) {
            throw new IOException("Too many redirects (" + retryNumber + ")");
        }
        if (retryNumber > 1) {
            log.debug((Object)("Retry number " + retryNumber));
        }
        log.debug((Object)("Open [" + urlString + "]"));
        DBPPreferenceStore prefs = DBeaverCore.getGlobalPreferenceStore();
        String proxyHost = prefs.getString("ui.proxy.host");
        Proxy proxy = null;
        if (!CommonUtils.isEmpty((String)proxyHost)) {
            int proxyPort = prefs.getInt("ui.proxy.port");
            if (proxyPort <= 0) {
                log.warn((Object)("Invalid proxy port: " + proxyPort));
            }
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        }
        URL url = new URL(urlString);
        URLConnection connection = proxy == null ? url.openConnection() : url.openConnection(proxy);
        connection.setReadTimeout(10000);
        connection.setConnectTimeout(10000);
        if (connection instanceof HttpURLConnection) {
            httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod("GET");
            httpConnection.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            connection.setRequestProperty("User-Agent", GeneralUtils.getProductTitle());
            if (authInfo != null && !CommonUtils.isEmpty((String)authInfo.getUserName())) {
                String encoded = Base64.getEncoder().encodeToString((String.valueOf(authInfo.getUserName()) + ":" + CommonUtils.notEmpty((String)authInfo.getUserPassword())).getBytes(GeneralUtils.UTF8_CHARSET));
                connection.setRequestProperty("Authorization", "Basic " + encoded);
            }
        }
        connection.connect();
        if (connection instanceof HttpURLConnection && (responseCode = (httpConnection = (HttpURLConnection)connection).getResponseCode()) != 200) {
            if (responseCode == 302 || responseCode == 301 || responseCode == 303) {
                String newUrl = connection.getHeaderField("Location");
                return WebUtils.openURLConnection(newUrl, authInfo, retryNumber + 1);
            }
            throw new IOException("Can't open '" + urlString + "': " + httpConnection.getResponseMessage());
        }
        return connection;
    }

    public static void openWebBrowser(String url) {
        if (!((url = url.trim()).startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://"))) {
            url = "http://" + url;
        }
        Program.launch((String)url);
    }
}

