/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.transfer.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.utils.CommonUtils;

public class DataTransferRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataTransfer";
    private static DataTransferRegistry instance = null;
    private static final Log log = Log.getLog(DataTransferRegistry.class);
    private List<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();

    public static synchronized DataTransferRegistry getInstance() {
        if (instance == null) {
            instance = new DataTransferRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataTransferRegistry(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if ("node".equals(ext.getName()) && CommonUtils.isEmpty((String)ext.getAttribute("ref"))) {
                this.nodes.add(new DataTransferNodeDescriptor(ext));
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            String nodeReference;
            ext = iConfigurationElementArray[n2];
            if ("node".equals(ext.getName()) && !CommonUtils.isEmpty((String)(nodeReference = ext.getAttribute("ref")))) {
                DataTransferNodeDescriptor refNode = this.getNodeById(nodeReference);
                if (refNode == null) {
                    log.error((Object)("Referenced data transfer node '" + nodeReference + "' not found"));
                } else {
                    refNode.loadNodeConfigurations(ext);
                }
            }
            ++n2;
        }
        this.nodes.sort(Comparator.comparing(DataTransferNodeDescriptor::getName));
    }

    public List<DataTransferNodeDescriptor> getAvailableProducers(Collection<DBSObject> sourceObjects) {
        return this.getAvailableNodes(DataTransferNodeDescriptor.NodeType.PRODUCER, sourceObjects);
    }

    public List<DataTransferNodeDescriptor> getAvailableConsumers(Collection<DBSObject> sourceObjects) {
        return this.getAvailableNodes(DataTransferNodeDescriptor.NodeType.CONSUMER, sourceObjects);
    }

    List<DataTransferNodeDescriptor> getAvailableNodes(DataTransferNodeDescriptor.NodeType nodeType, Collection<DBSObject> sourceObjects) {
        ArrayList<DataTransferNodeDescriptor> result = new ArrayList<DataTransferNodeDescriptor>();
        block0: for (DataTransferNodeDescriptor node : this.nodes) {
            if (node.getNodeType() != nodeType) continue;
            for (DBSObject sourceObject : sourceObjects) {
                if (!node.appliesToType(sourceObject.getClass())) continue;
                result.add(node);
                continue block0;
            }
        }
        return result;
    }

    public DataTransferNodeDescriptor getNodeByType(Class<? extends IDataTransferNode> type) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (!node.getNodeClass().equals(type)) continue;
            return node;
        }
        return null;
    }

    public DataTransferNodeDescriptor getNodeById(String id) {
        for (DataTransferNodeDescriptor node : this.nodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }
}

