/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.transfer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPRegistryDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.registry.transfer.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferProcessorDescriptor
extends AbstractDescriptor
implements DBPRegistryDescriptor<IDataTransferProcessor> {
    private final DataTransferNodeDescriptor node;
    private final String id;
    private final AbstractDescriptor.ObjectType processorType;
    private final List<AbstractDescriptor.ObjectType> sourceTypes = new ArrayList<AbstractDescriptor.ObjectType>();
    private final String name;
    private final String description;
    @NotNull
    private final DBPImage icon;
    private final List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private boolean isBinary;

    DataTransferProcessorDescriptor(DataTransferNodeDescriptor node, IConfigurationElement config) {
        super(config);
        this.node = node;
        this.id = config.getAttribute("id");
        this.processorType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"), (DBPImage)DBIcon.TYPE_UNKNOWN);
        this.isBinary = CommonUtils.getBoolean((String)config.getAttribute("binary"), (boolean)false);
        for (IConfigurationElement typeCfg : ArrayUtils.safeArray((Object[])config.getChildren("sourceType"))) {
            this.sourceTypes.add(new AbstractDescriptor.ObjectType((AbstractDescriptor)this, typeCfg.getAttribute("type")));
        }
        for (IConfigurationElement prop : ArrayUtils.safeArray((Object[])config.getChildren("propertyGroup"))) {
            this.properties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public DBPImage getIcon() {
        return this.icon;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    boolean appliesToType(Class objectType) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
            if (!sourceType.matchesType(objectType)) continue;
            return true;
        }
        return false;
    }

    public boolean adaptsToType(IAdaptable adaptable) {
        if (this.sourceTypes.isEmpty()) {
            return true;
        }
        for (AbstractDescriptor.ObjectType sourceType : this.sourceTypes) {
            if (adaptable.getAdapter(sourceType.getObjectClass()) == null) continue;
            return true;
        }
        return false;
    }

    public IDataTransferProcessor getInstance() {
        try {
            this.processorType.checkObjectClass(IDataTransferProcessor.class);
            Class clazz = this.processorType.getObjectClass(IDataTransferProcessor.class);
            return (IDataTransferProcessor)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't instantiate data exporter", e);
        }
    }

    public DataTransferNodeDescriptor getNode() {
        return this.node;
    }

    public boolean isBinaryFormat() {
        return this.isBinary;
    }
}

