/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeIcon;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class DataSourceProviderDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataSourceProviderDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataSourceProvider";
    private DataSourceProviderRegistry registry;
    private DataSourceProviderDescriptor parentProvider;
    private final String id;
    private final AbstractDescriptor.ObjectType implType;
    private final String name;
    private final String description;
    private DBPImage icon;
    private DBPDataSourceProvider instance;
    private DBXTreeItem treeDescriptor;
    private final Map<String, DBXTreeNode> treeNodeMap = new HashMap<String, DBXTreeNode>();
    private boolean driversManagable;
    private final List<DBPPropertyDescriptor> driverProperties = new ArrayList<DBPPropertyDescriptor>();
    private final List<DriverDescriptor> drivers = new ArrayList<DriverDescriptor>();
    private final List<DataSourceViewDescriptor> views = new ArrayList<DataSourceViewDescriptor>();

    public DataSourceProviderDescriptor(DataSourceProviderRegistry registry, IConfigurationElement config) {
        super(config);
        int n;
        IConfigurationElement[] iConfigurationElementArray;
        Object[] trees;
        this.registry = registry;
        String parentId = config.getAttribute("parent");
        if (!CommonUtils.isEmpty((String)parentId)) {
            this.parentProvider = registry.getDataSourceProvider(parentId);
            if (this.parentProvider == null) {
                log.error((Object)("Provider '" + parentId + "' not found"));
            }
        }
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        if (this.icon == null) {
            this.icon = UIIcon.GEN_DATABASE_TYPE;
        }
        if (!ArrayUtils.isEmpty((Object[])(trees = config.getChildren("tree")))) {
            this.treeDescriptor = this.loadTreeInfo((IConfigurationElement)trees[0]);
        } else if (this.parentProvider != null) {
            this.treeDescriptor = new DBXTreeItem((AbstractDescriptor)this, null, this.parentProvider.treeDescriptor);
        }
        Object[] injections = config.getChildren("treeInjection");
        if (!ArrayUtils.isEmpty((Object[])injections)) {
            Object[] objectArray = injections;
            int n2 = injections.length;
            int n3 = 0;
            while (n3 < n2) {
                Object treeInject = objectArray[n3];
                this.injectTreeNodes((IConfigurationElement)treeInject);
                ++n3;
            }
        }
        if (this.parentProvider != null) {
            this.driverProperties.addAll(this.parentProvider.driverProperties);
        }
        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren("driver-properties");
        int n4 = iConfigurationElementArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            IConfigurationElement propsElement = iConfigurationElementArray2[n5];
            iConfigurationElementArray = propsElement.getChildren("propertyGroup");
            n = iConfigurationElementArray.length;
            int n6 = 0;
            while (n6 < n) {
                IConfigurationElement prop = iConfigurationElementArray[n6];
                this.driverProperties.addAll(PropertyDescriptor.extractProperties((IConfigurationElement)prop));
                ++n6;
            }
            ++n5;
        }
        iConfigurationElementArray2 = config.getChildren("drivers");
        n4 = iConfigurationElementArray2.length;
        n5 = 0;
        while (n5 < n4) {
            IConfigurationElement driversElement = iConfigurationElementArray2[n5];
            this.driversManagable = driversElement.getAttribute("managable") == null || CommonUtils.getBoolean((String)driversElement.getAttribute("managable"));
            iConfigurationElementArray = driversElement.getChildren("driver");
            n = iConfigurationElementArray.length;
            int n7 = 0;
            while (n7 < n) {
                IConfigurationElement driverElement = iConfigurationElementArray[n7];
                try {
                    this.drivers.add(this.loadDriver(driverElement));
                }
                catch (Exception e) {
                    log.error((Object)"Error loading driver", (Throwable)e);
                }
                ++n7;
            }
            ++n5;
        }
        iConfigurationElementArray2 = config.getChildren("views");
        n4 = iConfigurationElementArray2.length;
        n5 = 0;
        while (n5 < n4) {
            IConfigurationElement viewsElement = iConfigurationElementArray2[n5];
            iConfigurationElementArray = viewsElement.getChildren("view");
            n = iConfigurationElementArray.length;
            int n8 = 0;
            while (n8 < n) {
                IConfigurationElement viewElement = iConfigurationElementArray[n8];
                this.views.add(new DataSourceViewDescriptor(this, viewElement));
                ++n8;
            }
            ++n5;
        }
        if (this.views.isEmpty() && this.parentProvider != null) {
            this.views.addAll(this.parentProvider.views);
        }
    }

    public void dispose() {
        this.drivers.clear();
        this.instance = null;
    }

    public DataSourceProviderRegistry getRegistry() {
        return this.registry;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    @NotNull
    public DBPDataSourceProvider getInstance(DriverDescriptor driver) {
        if (this.instance == null) {
            this.initProviderBundle(driver);
            try {
                this.instance = (DBPDataSourceProvider)this.implType.createInstance(DBPDataSourceProvider.class);
                this.instance.init((DBPPlatform)DBeaverCore.getInstance());
            }
            catch (Throwable ex) {
                this.instance = null;
                throw new IllegalStateException("Can't initialize data source provider '" + this.implType.getImplName() + "'", ex);
            }
        }
        return this.instance;
    }

    private void initProviderBundle(DriverDescriptor driver) {
    }

    public DBXTreeNode getTreeDescriptor() {
        return this.treeDescriptor;
    }

    public boolean isDriversManagable() {
        return this.driversManagable;
    }

    public List<DBPPropertyDescriptor> getDriverProperties() {
        return this.driverProperties;
    }

    public DBPPropertyDescriptor getDriverProperty(String name) {
        for (DBPPropertyDescriptor prop : this.driverProperties) {
            if (!prop.getId().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public List<DriverDescriptor> getDrivers() {
        return this.drivers;
    }

    public List<DriverDescriptor> getEnabledDrivers() {
        ArrayList<DriverDescriptor> eDrivers = new ArrayList<DriverDescriptor>();
        for (DriverDescriptor driver : this.drivers) {
            if (driver.isDisabled() || driver.getReplacedBy() != null || !driver.isSupportedByLocalSystem()) continue;
            eDrivers.add(driver);
        }
        return eDrivers;
    }

    public DriverDescriptor getDriver(String id) {
        for (DriverDescriptor driver : this.drivers) {
            if (!driver.getId().equals(id)) continue;
            while (driver.getReplacedBy() != null) {
                driver = driver.getReplacedBy();
            }
            return driver;
        }
        return null;
    }

    public DriverDescriptor createDriver() {
        return this.createDriver(SecurityUtils.generateGUID((boolean)false));
    }

    public DriverDescriptor createDriver(String id) {
        return new DriverDescriptor(this, id);
    }

    public DriverDescriptor createDriver(DriverDescriptor copyFrom) {
        return new DriverDescriptor(this, SecurityUtils.generateGUID((boolean)false), copyFrom);
    }

    public void addDriver(DriverDescriptor driver) {
        this.drivers.add(driver);
    }

    public boolean removeDriver(DriverDescriptor driver) {
        if (!driver.isCustom()) {
            driver.setDisabled(true);
            driver.setModified(true);
            return true;
        }
        return this.drivers.remove((Object)driver);
    }

    public DataSourceViewDescriptor getView(String targetID) {
        for (DataSourceViewDescriptor view : this.views) {
            if (!view.getTargetID().equals(targetID)) continue;
            return view;
        }
        return null;
    }

    private DBXTreeItem loadTreeInfo(IConfigurationElement config) {
        DBXTreeItem treeRoot = new DBXTreeItem((AbstractDescriptor)this, null, config.getAttribute("id"), CoreMessages.model_navigator_Connection, CoreMessages.model_navigator_Connection, config.getAttribute("path"), null, false, true, false, false, false, config.getAttribute("visibleIf"), null);
        this.loadTreeChildren(config, (DBXTreeNode)treeRoot);
        this.loadTreeIcon((DBXTreeNode)treeRoot, config);
        return treeRoot;
    }

    private void injectTreeNodes(IConfigurationElement config) {
        String injectPath = config.getAttribute("path");
        if (CommonUtils.isEmpty((String)injectPath)) {
            return;
        }
        String[] path = injectPath.split("/");
        if (path.length <= 0) {
            return;
        }
        if (!path[0].equals(this.treeDescriptor.getPath())) {
            return;
        }
        DBXTreeItem baseItem = this.treeDescriptor;
        int i = 1;
        while (i < path.length) {
            if ((baseItem = baseItem.findChildItemByPath(path[i])) == null) {
                return;
            }
            ++i;
        }
        this.loadTreeChildren(config, (DBXTreeNode)baseItem);
    }

    private void loadTreeChildren(IConfigurationElement config, DBXTreeNode parent) {
        Object[] children = config.getChildren();
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.loadTreeNode(parent, (IConfigurationElement)child);
                ++n2;
            }
        }
    }

    private void loadTreeNode(DBXTreeNode parent, IConfigurationElement config) {
        DBXTreeNode child = null;
        String refId = config.getAttribute("ref");
        if (!CommonUtils.isEmpty((String)refId)) {
            child = this.treeNodeMap.get(refId);
            if (child != null) {
                parent.addChild(child);
            } else {
                log.warn((Object)("Bad node reference: " + refId));
            }
        } else {
            String nodeType = config.getName();
            if (nodeType.equals("folder")) {
                DBXTreeFolder folder = new DBXTreeFolder((AbstractDescriptor)this, parent, config.getAttribute("id"), config.getAttribute("type"), config.getAttribute("label"), CommonUtils.getBoolean((String)config.getAttribute("navigable"), (boolean)true), CommonUtils.getBoolean((String)config.getAttribute("virtual")), config.getAttribute("visibleIf"));
                folder.setDescription(config.getAttribute("description"));
                child = folder;
            } else if (nodeType.equals("items")) {
                String recursive = config.getAttribute("recursive");
                child = new DBXTreeItem((AbstractDescriptor)this, parent, config.getAttribute("id"), config.getAttribute("label"), config.getAttribute("itemLabel"), config.getAttribute("path"), config.getAttribute("property"), CommonUtils.getBoolean((String)config.getAttribute("optional")), CommonUtils.getBoolean((String)config.getAttribute("navigable"), (boolean)true), CommonUtils.getBoolean((String)config.getAttribute("inline")), CommonUtils.getBoolean((String)config.getAttribute("virtual")), CommonUtils.getBoolean((String)config.getAttribute("standalone")), config.getAttribute("visibleIf"), recursive);
            } else if (nodeType.equals("object")) {
                child = new DBXTreeObject((AbstractDescriptor)this, parent, config.getAttribute("id"), config.getAttribute("visibleIf"), config.getAttribute("label"), config.getAttribute("description"), config.getAttribute("editor"));
            }
            if (child != null) {
                if (!CommonUtils.isEmpty((String)child.getId())) {
                    this.treeNodeMap.put(child.getId(), child);
                }
                this.loadTreeHandlers(child, config);
                this.loadTreeIcon(child, config);
                this.loadTreeChildren(config, child);
            }
        }
    }

    private void loadTreeHandlers(DBXTreeNode node, IConfigurationElement config) {
        Object[] handlerElements = config.getChildren("handler");
        if (!ArrayUtils.isEmpty((Object[])handlerElements)) {
            Object[] objectArray = handlerElements;
            int n = handlerElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object iconElement = objectArray[n2];
                try {
                    DBXTreeNodeHandler.Action action = DBXTreeNodeHandler.Action.valueOf((String)iconElement.getAttribute("action"));
                    String performName = iconElement.getAttribute("perform");
                    String command = iconElement.getAttribute("command");
                    DBXTreeNodeHandler.Perform perform = !CommonUtils.isEmpty((String)performName) ? DBXTreeNodeHandler.Perform.valueOf((String)performName) : (!CommonUtils.isEmpty((String)command) ? DBXTreeNodeHandler.Perform.command : DBXTreeNodeHandler.Perform.none);
                    node.addActionHandler(action, perform, command);
                }
                catch (Exception e) {
                    log.error((Object)"Error adding node handler", (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private void loadTreeIcon(DBXTreeNode node, IConfigurationElement config) {
        DBPImage defaultImage;
        String defaultIcon = config.getAttribute("icon");
        Object[] iconElements = config.getChildren("icon");
        if (!ArrayUtils.isEmpty((Object[])iconElements)) {
            Object[] objectArray = iconElements;
            int n = iconElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object iconElement = objectArray[n2];
                String icon = iconElement.getAttribute("icon");
                String expr = iconElement.getAttribute("if");
                boolean isDefault = CommonUtils.getBoolean((String)iconElement.getAttribute("default"));
                if (isDefault && CommonUtils.isEmpty((String)expr)) {
                    defaultIcon = icon;
                } else {
                    DBPImage iconImage = this.iconToImage(icon);
                    if (iconImage != null) {
                        node.addIcon(new DBXTreeIcon(expr, iconImage));
                    }
                }
                ++n2;
            }
        }
        if (defaultIcon != null && (defaultImage = this.iconToImage(defaultIcon)) != null) {
            node.setDefaultIcon(defaultImage);
        }
    }

    private DriverDescriptor loadDriver(IConfigurationElement config) {
        return new DriverDescriptor(this, config);
    }

    public void loadTemplateVariableResolvers(TemplateContextType contextType) {
    }

    public String toString() {
        return this.id;
    }

    public String getFullIdentifier() {
        return String.valueOf(this.getPluginId()) + '/' + this.id;
    }

    public DriverDescriptor getDriverByName(String category, String name) {
        if (category != null && category.isEmpty()) {
            category = null;
        }
        for (DriverDescriptor driver : this.drivers) {
            if (!CommonUtils.equalObjects((Object)category, (Object)driver.getCategory()) || !CommonUtils.equalObjects((Object)name, (Object)driver.getName())) continue;
            return driver;
        }
        return null;
    }
}

