/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.ui;

import org.eclipse.core.runtime.IStatus;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;

public class DBUserInterface {
    private static DBPPlatformUI instance = new DBPPlatformUI(){

        @Override
        public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull IStatus status) {
            System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
            this.printStatus(status, 0);
            return DBPPlatformUI.UserResponse.OK;
        }

        @Override
        public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull Throwable e) {
            System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
            e.printStackTrace(System.out);
            return DBPPlatformUI.UserResponse.OK;
        }

        @Override
        public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message) {
            System.out.println(String.valueOf(title) + (message == null ? "" : ": " + message));
            return DBPPlatformUI.UserResponse.OK;
        }

        private void printStatus(@NotNull IStatus status, int level) {
            char[] indent = new char[level * 4];
            int i = 0;
            while (i < indent.length) {
                indent[i] = 32;
                ++i;
            }
            if (status.getMessage() != null) {
                System.out.println(indent + status.getMessage());
            }
            if (status.getException() != null) {
                status.getException().printStackTrace(System.out);
            }
        }

        @Override
        public DBAAuthInfo promptUserCredentials(String prompt, String userName, String userPassword, boolean passwordOnly) {
            return null;
        }

        @Override
        public DBAPasswordChangeInfo promptUserPasswordChange(String prompt, String userName, String oldPassword) {
            return null;
        }

        @Override
        public void executeProcess(DBRProcessDescriptor processDescriptor) {
            try {
                processDescriptor.execute();
            }
            catch (DBException e) {
                DBUserInterface.getInstance().showError("Execute process", processDescriptor.getName(), e);
            }
        }

        @Override
        public void executeInUI(Runnable runnable) {
            runnable.run();
        }
    };

    public static DBPPlatformUI getInstance() {
        return instance;
    }

    public static void setInstance(DBPPlatformUI instance) {
        DBUserInterface.instance = instance;
    }
}

