/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import org.jkiss.dbeaver.utils.GeneralUtils;

public class SQLQueryParameter {
    private int ordinalPosition;
    private String name;
    private String value;
    private final int tokenOffset;
    private final int tokenLength;
    private SQLQueryParameter previous;

    public SQLQueryParameter(int ordinalPosition, String name) {
        this(ordinalPosition, name, 0, 0);
    }

    public SQLQueryParameter(int ordinalPosition, String name, int tokenOffset, int tokenLength) {
        if (tokenOffset < 0) {
            throw new IndexOutOfBoundsException("Bad parameter offset: " + tokenOffset);
        }
        if (tokenLength < 0) {
            throw new IndexOutOfBoundsException("Bad parameter length: " + tokenLength);
        }
        this.ordinalPosition = ordinalPosition;
        this.name = name.trim();
        this.tokenOffset = tokenOffset;
        this.tokenLength = tokenLength;
    }

    public boolean isNamed() {
        return !"?".equals(this.name);
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public SQLQueryParameter getPrevious() {
        return this.previous;
    }

    public void setPrevious(SQLQueryParameter previous) {
        this.previous = previous;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getTitle() {
        if (GeneralUtils.isVariablePattern(this.name)) {
            return GeneralUtils.stripVariablePattern(this.name);
        }
        if (this.name.startsWith(":")) {
            return this.name.substring(1);
        }
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + "=" + this.value;
    }
}

