/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.BaseValueHandler;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class TemporalAccessorValueHandler
extends BaseValueHandler {
    protected static final Log log = Log.getLog(TemporalAccessorValueHandler.class);
    private final DBDDataFormatterProfile formatterProfile;
    protected DBDDataFormatter formatter;

    public TemporalAccessorValueHandler(DBDDataFormatterProfile formatterProfile) {
        this.formatterProfile = formatterProfile;
    }

    @NotNull
    public Class<Date> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Date.class;
    }

    @Override
    public TemporalAccessor getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof TemporalAccessor) {
            return (TemporalAccessor)object;
        }
        if (object instanceof String) {
            String strValue = (String)object;
            try {
                return (TemporalAccessor)this.getFormatter(type).parseValue(strValue, this.isZonedType(type) ? ZonedDateTime.class : LocalDateTime.class);
            }
            catch (ParseException e) {
                try {
                    return ZonedDateTime.parse((CharSequence)object);
                }
                catch (Exception exception) {
                    log.debug("Can't parse string value [" + strValue + "] to date/time value", e);
                    return null;
                }
            }
        }
        throw new DBCException("Bad temporal accessor value: " + object);
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value == null) {
            return super.getValueDisplayString(column, null, format);
        }
        try {
            return this.getFormatter(column).formatValue(value);
        }
        catch (Exception exception) {
            return String.valueOf(value);
        }
    }

    @NotNull
    protected DBDDataFormatter getFormatter(DBSTypedObject column) {
        if (this.formatter == null) {
            try {
                this.formatter = this.formatterProfile.createFormatter(this.getFormatterId(column), column);
            }
            catch (Exception e) {
                log.error("Can't create formatter for zoned datetime value handler", e);
                this.formatter = DefaultDataFormatter.INSTANCE;
            }
        }
        return this.formatter;
    }

    protected abstract boolean isZonedType(DBSTypedObject var1);

    @NotNull
    protected abstract String getFormatterId(DBSTypedObject var1);
}

