/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;

public class ApplicationRegistry {
    private static final Log log = Log.getLog(ApplicationRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.application";
    private static ApplicationRegistry instance = null;
    private final List<ApplicationDescriptor> applications = new ArrayList<ApplicationDescriptor>();
    private ApplicationDescriptor defaultApplication;

    public static synchronized ApplicationRegistry getInstance() {
        if (instance == null) {
            instance = new ApplicationRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ApplicationRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            ApplicationDescriptor app = new ApplicationDescriptor(ext);
            this.applications.add(app);
            ++n2;
        }
        for (ApplicationDescriptor app : this.applications) {
            if (app.getParentId() == null) continue;
            ApplicationDescriptor parentApp = this.getApplication(app.getParentId());
            if (parentApp == null) {
                log.error("Parent application '" + app.getParentId() + "' not found");
                continue;
            }
            app.setParent(parentApp);
        }
        ArrayList<ApplicationDescriptor> finalApps = new ArrayList<ApplicationDescriptor>();
        for (ApplicationDescriptor app : this.applications) {
            if (!app.isFinalApplication()) continue;
            finalApps.add(app);
        }
        if (finalApps.isEmpty()) {
            log.error("No applications defined.");
        } else {
            this.defaultApplication = (ApplicationDescriptor)finalApps.get(0);
            if (finalApps.size() > 1) {
                log.error("Multiple application defined. Use first one (" + this.defaultApplication.getId() + ")");
            }
        }
    }

    private ApplicationDescriptor getApplication(String id) {
        for (ApplicationDescriptor app : this.applications) {
            if (!app.getId().equals(id)) continue;
            return app;
        }
        return null;
    }

    public ApplicationDescriptor getApplication() {
        if (this.defaultApplication == null) {
            throw new IllegalStateException("No DBeaver application was defined");
        }
        return this.defaultApplication;
    }
}

