/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeConstraintBase {
    private int orderPosition;
    private boolean orderDescending;
    private String criteria;
    private DBCLogicalOperator operator;
    private boolean reverseOperator;
    private Object value;
    private boolean visible;
    private int visualPosition;
    private String entityAlias;

    public DBDAttributeConstraintBase() {
    }

    public DBDAttributeConstraintBase(DBDAttributeConstraintBase source) {
        this.copyFrom(source);
    }

    public void copyFrom(DBDAttributeConstraintBase source) {
        this.orderPosition = source.orderPosition;
        this.orderDescending = source.orderDescending;
        this.criteria = source.criteria;
        this.operator = source.operator;
        this.reverseOperator = source.reverseOperator;
        this.value = source.value;
        this.visible = source.visible;
        this.visualPosition = source.visualPosition;
    }

    public int getOrderPosition() {
        return this.orderPosition;
    }

    public void setOrderPosition(int orderPosition) {
        this.orderPosition = orderPosition;
    }

    public boolean isOrderDescending() {
        return this.orderDescending;
    }

    public void setOrderDescending(boolean orderDescending) {
        this.orderDescending = orderDescending;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public void setCriteria(@Nullable String criteria) {
        this.criteria = criteria;
        this.operator = null;
        this.reverseOperator = false;
        this.value = null;
    }

    public DBCLogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DBCLogicalOperator operator) {
        this.criteria = null;
        this.operator = operator;
    }

    public boolean isReverseOperator() {
        return this.reverseOperator;
    }

    public void setReverseOperator(boolean reverseOperator) {
        this.reverseOperator = reverseOperator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) {
        this.criteria = null;
        this.value = value;
    }

    public boolean hasFilter() {
        return this.hasCondition() || this.orderPosition > 0 || !this.visible;
    }

    public boolean hasCondition() {
        return !CommonUtils.isEmpty((String)this.criteria) || this.operator != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getVisualPosition() {
        return this.visualPosition;
    }

    public void setVisualPosition(int visualPosition) {
        this.visualPosition = visualPosition;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    public void reset() {
        this.orderPosition = 0;
        this.orderDescending = false;
        this.criteria = null;
        this.operator = null;
        this.reverseOperator = false;
        this.value = null;
        this.visible = true;
    }

    public boolean equalFilters(DBDAttributeConstraintBase obj, boolean compareOrders) {
        if (compareOrders && (this.orderPosition != obj.orderPosition || this.orderDescending != obj.orderDescending)) {
            return false;
        }
        return CommonUtils.equalObjects((Object)this.criteria, (Object)obj.criteria) && CommonUtils.equalObjects((Object)((Object)this.operator), (Object)((Object)obj.operator)) && CommonUtils.equalObjects((Object)this.reverseOperator, (Object)obj.reverseOperator) && CommonUtils.equalObjects((Object)this.value, (Object)obj.value);
    }

    public int hashCode() {
        return this.orderPosition + (this.orderDescending ? 1 : 0) + (this.criteria == null ? 0 : this.criteria.hashCode()) + (this.operator == null ? 0 : this.operator.hashCode()) + (this.reverseOperator ? 1 : 0) + (this.value == null ? 0 : this.value.hashCode()) + (this.visible ? 1 : 0) + this.visualPosition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBDAttributeConstraintBase) {
            DBDAttributeConstraintBase source = (DBDAttributeConstraintBase)obj;
            return this.orderPosition == source.orderPosition && this.orderDescending == source.orderDescending && CommonUtils.equalObjects((Object)this.criteria, (Object)source.criteria) && CommonUtils.equalObjects((Object)((Object)this.operator), (Object)((Object)source.operator)) && this.reverseOperator == source.reverseOperator && CommonUtils.equalObjects((Object)this.value, (Object)source.value) && this.visible == source.visible && this.visualPosition == source.visualPosition;
        }
        return false;
    }
}

