/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.model;

import com.datastax.driver.core.Session;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CasExecutionContext
extends AbstractExecutionContext<CasDataSource> {
    private Session session;

    public CasExecutionContext(CasDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public Session getSession() {
        return this.session;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        DBExecUtils.startContextInitiation((DBCExecutionContext)this);
        try {
            try {
                monitor.subTask("Open cluster session");
                this.reconnect();
                this.initContextBootstrap(monitor, true);
                ((CasDataSource)this.dataSource).allContexts.add(this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, this.dataSource);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBCExecutionContext)this);
        }
    }

    @NotNull
    public CasSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new CasSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        throw new DBException("Connection invalidate not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        CasExecutionContext casExecutionContext = this;
        synchronized (casExecutionContext) {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
            super.closeContext();
        }
        ((CasDataSource)this.dataSource).allContexts.add(this);
    }

    public void reconnect() {
        String keyspaceName;
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        this.session = CommonUtils.isEmpty((String)(keyspaceName = ((CasDataSource)this.dataSource).getSelectedKeyspaceName())) ? ((CasDataSource)this.dataSource).getCluster().connect() : ((CasDataSource)this.dataSource).getCluster().connect(keyspaceName);
    }
}

