/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra.data.handlers;

import com.datastax.driver.core.DataType;
import com.dbeaver.ee.cassandra.data.CasUDTValue;
import com.dbeaver.ee.cassandra.data.handlers.CasComplexValueHandler;
import com.dbeaver.ee.cassandra.exec.CasPreparedStatement;
import com.dbeaver.ee.cassandra.exec.CasSession;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import com.dbeaver.ee.cassandra.model.CasTableColumn;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasUDTValueHandler
extends CasComplexValueHandler {
    private static final Log log = Log.getLog(CasUDTValueHandler.class);
    public static final CasUDTValueHandler INSTANCE = new CasUDTValueHandler();

    @NotNull
    public Class<CasUDTValue> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return CasUDTValue.class;
    }

    public CasUDTValue getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        if (object == null) {
            DataType dt = DataType.text();
            if (type instanceof CasTableColumn) {
                dt = ((CasTableColumn)type).getMetadata().getType();
            }
            CasDataSource dataSource = (CasDataSource)session.getDataSource();
            return new CasUDTValue(dataSource, dataSource.getSelectedKeyspaceName(), null);
        }
        if (object instanceof CasUDTValue) {
            return copy ? new CasUDTValue((CasUDTValue)object) : (CasUDTValue)object;
        }
        throw new DBCException("Unsupported UDT type: " + object.getClass().getName());
    }

    @Override
    protected void bindParameter(CasSession session, CasPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException {
        statement.getBoundStatement().setUDTValue(paramIndex, ((CasUDTValue)value).getRawValue());
    }

    public String getValueDisplayString(DBSTypedObject column, Object value, DBDDisplayFormat format) {
        if (value instanceof CasUDTValue) {
            return value.toString();
        }
        return super.getValueDisplayString(column, value, format);
    }
}

