/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.dbeaver.ee.cassandra.data.CasContentBytes;
import com.dbeaver.ee.cassandra.data.CasMapValue;
import com.dbeaver.ee.cassandra.data.CasSetValue;
import com.dbeaver.ee.cassandra.data.CasTupleValue;
import com.dbeaver.ee.cassandra.data.CasUDTValue;
import com.dbeaver.ee.cassandra.model.CasAbstractDataType;
import com.dbeaver.ee.cassandra.model.CasDataSource;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.TimeZone;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class CasUtils {
    private static final Log log = Log.getLog(CasUtils.class);
    private static Field typeProtocolField;

    static {
        try {
            typeProtocolField = DataType.Name.class.getDeclaredField("protocolId");
            typeProtocolField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            log.debug((Object)e);
        }
    }

    public static int getTypeNameID(DataType type) {
        return CasUtils.getTypeNameID(type.getName());
    }

    public static int getTypeNameID(DataType.Name typeName) {
        if (typeProtocolField != null) {
            try {
                return (Integer)typeProtocolField.get(typeName);
            }
            catch (Exception e) {
                log.debug((Object)"Error reading type ID", (Throwable)e);
            }
        }
        return typeName.ordinal();
    }

    public static DBPDataKind getDataKind(DataType dataType) {
        return CasUtils.getDataKind(dataType.getName());
    }

    public static DBPDataKind getDataKind(DataType.Name typeName) {
        switch (typeName) {
            case BOOLEAN: {
                return DBPDataKind.BOOLEAN;
            }
            case ASCII: 
            case TEXT: 
            case VARCHAR: {
                return DBPDataKind.STRING;
            }
            case BIGINT: 
            case COUNTER: 
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case VARINT: 
            case SMALLINT: 
            case TINYINT: {
                return DBPDataKind.NUMERIC;
            }
            case TIMESTAMP: 
            case DATE: 
            case TIME: {
                return DBPDataKind.DATETIME;
            }
            case CUSTOM: 
            case UUID: 
            case TIMEUUID: 
            case INET: 
            case TUPLE: {
                return DBPDataKind.OBJECT;
            }
            case UDT: {
                return DBPDataKind.STRUCT;
            }
            case MAP: {
                return DBPDataKind.ARRAY;
            }
            case LIST: 
            case SET: {
                return DBPDataKind.ARRAY;
            }
        }
        return DBPDataKind.BINARY;
    }

    public static String transformCQL(CasDataSource dataSource, String original, DBDDataFilter filter) {
        StringBuilder cql = new StringBuilder(original);
        if (filter != null && filter.hasConditions()) {
            cql.append(" WHERE ");
            SQLUtils.appendConditionString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)cql, (boolean)true);
        }
        if (filter != null && filter.hasOrdering()) {
            cql.append(" ORDER BY ");
            SQLUtils.appendOrderString((DBDDataFilter)filter, (DBPDataSource)dataSource, null, (StringBuilder)cql);
        }
        return cql.toString();
    }

    public static Object wrapValue(CasDataSource dataSource, String keyspace, Object value) throws DBCException {
        if (value instanceof ByteBuffer) {
            return new CasContentBytes(dataSource, (ByteBuffer)value);
        }
        return value;
    }

    public static Object unwrapValue(CasDataSource dataSource, Object value) {
        if (value instanceof CasContentBytes) {
            return ((CasContentBytes)((Object)value)).getData();
        }
        if (value instanceof CasSetValue) {
            return ((CasSetValue)value).makeSet();
        }
        if (value instanceof CasMapValue) {
            return ((CasMapValue)value).makeMap();
        }
        if (value instanceof CasUDTValue) {
            return ((CasUDTValue)value).getRawValue();
        }
        if (value instanceof CasTupleValue) {
            return ((CasTupleValue)value).getRawValue();
        }
        return value;
    }

    @NotNull
    public static LocalDate toLocalDate(Date date) {
        return LocalDate.fromMillisSinceEpoch((long)(date.getTime() + (long)TimeZone.getDefault().getRawOffset()));
    }

    public static long toCasTime(Date date) {
        return (date.getTime() + (long)TimeZone.getDefault().getRawOffset()) * 1000000L;
    }

    public static CasAbstractDataType resolveDataType(DBRProgressMonitor monitor, CasDataSource dataSource, String keyspace, DataType dataType) throws DBException {
        if (dataType instanceof TupleType) {
            return dataSource.getCachedTupleType((TupleType)dataType);
        }
        if (dataType instanceof UserType) {
            return dataSource.getKeyspace(keyspace).getUserType(monitor, dataType);
        }
        return dataSource.getLocalDataType(dataType.toString());
    }
}

