/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.editors;

import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.editors.sql.SQLSourceViewer;
import org.jkiss.utils.CommonUtils;

public class PostgreSourceViewEditor
extends SQLSourceViewer<PostgreScriptObject> {
    private Boolean showPermissions;
    private boolean showColumnComments = true;

    protected boolean isReadOnly() {
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        return !(sourceObject instanceof PostgreProcedure) && !(sourceObject instanceof PostgreTrigger) && !(sourceObject instanceof PostgreViewBase);
    }

    public boolean getShowPermissions() {
        return this.showPermissions != null ? this.showPermissions : this.getSourceObject() instanceof PostgreTableBase;
    }

    protected void setSourceText(DBRProgressMonitor monitor, String sourceText) {
        this.getEditorInput().getPropertySource().setPropertyValue(monitor, (Object)"objectDefinitionText", (Object)sourceText);
    }

    protected void contributeEditorCommands(IContributionManager contributionManager) {
        super.contributeEditorCommands(contributionManager);
        PostgreScriptObject sourceObject = (PostgreScriptObject)this.getSourceObject();
        if (sourceObject instanceof PostgreProcedure) {
            contributionManager.add((IContributionItem)new Separator());
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show header", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PROCEDURE));
                    this.setToolTipText("Shows auto-generated function header");
                    this.setChecked(!PostgreSourceViewEditor.this.isInDebugMode());
                }

                public void run() {
                    PostgreSourceViewEditor.this.getEditorInput().setAttribute("debugger.source", (Object)(!this.isChecked() ? 1 : 0));
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
        if (sourceObject instanceof PostgrePermissionsOwner) {
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show permissions", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_PERMISSIONS));
                    this.setToolTipText("Shows object permission grants");
                    this.setChecked(PostgreSourceViewEditor.this.getShowPermissions());
                }

                public void run() {
                    PostgreSourceViewEditor.this.showPermissions = this.isChecked();
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
        if (sourceObject instanceof PostgreTableBase) {
            contributionManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action("Show comments", 2){
                {
                    this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TYPE_TEXT));
                    this.setToolTipText("Show column comments in table definition");
                    this.setChecked(PostgreSourceViewEditor.this.showColumnComments);
                }

                public void run() {
                    PostgreSourceViewEditor.this.showColumnComments = this.isChecked();
                    PostgreSourceViewEditor.this.refreshPart((Object)PostgreSourceViewEditor.this, true);
                }
            }, (boolean)true));
        }
    }

    protected Map<String, Object> getSourceOptions() {
        Map options = super.getSourceOptions();
        boolean inDebug = this.isInDebugMode();
        options.put("debugger.source", inDebug);
        options.put("pg.ddl.show.permissions", this.getShowPermissions());
        options.put("pg.ddl.show.column.comments", this.showColumnComments);
        return options;
    }

    private boolean isInDebugMode() {
        return CommonUtils.getBoolean((Object)this.getEditorInput().getAttribute("debugger.source"), (boolean)false);
    }
}

