/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class PostgreCreateDatabaseDialog
extends BaseDialog {
    private final PostgreDataSource dataSource;
    private List<PostgreRole> allUsers;
    private List<PostgreCharset> allEncodings;
    private List<PostgreCollation> allCollations;
    private List<PostgreTablespace> allTablespaces;
    private List<String> allTemplates;
    private String name;
    private PostgreRole owner;
    private String dbTemplate;
    private PostgreCharset encoding;
    private PostgreTablespace tablespace;

    public PostgreCreateDatabaseDialog(Shell parentShell, PostgreDataSource dataSource) {
        super(parentShell, PostgreMessages.dialog_create_db_title, null);
        this.dataSource = dataSource;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group groupGeneral = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_create_db_group_general, (int)2, (int)768, (int)0);
        final Text nameText = UIUtils.createLabelText((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_db_name, (String)"");
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PostgreCreateDatabaseDialog.this.name = nameText.getText();
                PostgreCreateDatabaseDialog.this.getButton(0).setEnabled(!PostgreCreateDatabaseDialog.this.name.isEmpty());
            }
        });
        final Combo userCombo = UIUtils.createLabelCombo((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_owner, (int)2060);
        userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateDatabaseDialog.this.owner = (PostgreRole)PostgreCreateDatabaseDialog.this.allUsers.get(userCombo.getSelectionIndex());
            }
        });
        Group groupDefinition = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.dialog_create_db_group_definition, (int)2, (int)768, (int)0);
        final Combo templateCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_template_db, (int)2060);
        templateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateDatabaseDialog.this.dbTemplate = templateCombo.getText();
            }
        });
        final Combo encodingCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_encoding, (int)2060);
        encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateDatabaseDialog.this.encoding = (PostgreCharset)PostgreCreateDatabaseDialog.this.allEncodings.get(encodingCombo.getSelectionIndex());
            }
        });
        final Combo tablespaceCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_tablesapce, (int)2060);
        tablespaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreCreateDatabaseDialog.this.tablespace = (PostgreTablespace)PostgreCreateDatabaseDialog.this.allTablespaces.get(tablespaceCombo.getSelectionIndex());
            }
        });
        new AbstractJob("Load users"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    PostgreDatabase database = PostgreCreateDatabaseDialog.this.dataSource.getDefaultInstance();
                    PostgreCreateDatabaseDialog.this.allUsers = new ArrayList<PostgreRole>(database.getUsers(monitor));
                    PostgreCreateDatabaseDialog.this.allEncodings = new ArrayList<PostgreCharset>(database.getEncodings(monitor));
                    PostgreCreateDatabaseDialog.this.allTablespaces = new ArrayList<PostgreTablespace>(database.getTablespaces(monitor));
                    PostgreCreateDatabaseDialog.this.allTemplates = new ArrayList<String>(PostgreCreateDatabaseDialog.this.dataSource.getTemplateDatabases(monitor));
                    PostgreRole dba = database.getDBA(monitor);
                    final String defUserName = dba == null ? "" : dba.getName();
                    final PostgreCharset defCharset = database.getDefaultEncoding(monitor);
                    final PostgreTablespace defTablespace = database.getDefaultTablespace(monitor);
                    UIUtils.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (PostgreRole authId : PostgreCreateDatabaseDialog.this.allUsers) {
                                String name = authId.getName();
                                userCombo.add(name);
                                if (!name.equals(defUserName)) continue;
                                PostgreCreateDatabaseDialog.this.owner = authId;
                            }
                            userCombo.setText(defUserName);
                            templateCombo.add("");
                            for (String tpl : PostgreCreateDatabaseDialog.this.allTemplates) {
                                templateCombo.add(tpl);
                            }
                            for (PostgreCharset charset : PostgreCreateDatabaseDialog.this.allEncodings) {
                                encodingCombo.add(charset.getName());
                                if (charset != defCharset) continue;
                                PostgreCreateDatabaseDialog.this.encoding = defCharset;
                            }
                            encodingCombo.setText(defCharset.getName());
                            for (PostgreTablespace ts : PostgreCreateDatabaseDialog.this.allTablespaces) {
                                tablespaceCombo.add(ts.getName());
                                if (ts != defTablespace) continue;
                                PostgreCreateDatabaseDialog.this.tablespace = ts;
                            }
                            tablespaceCombo.setText(defTablespace.getName());
                        }
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    public String getTemplateName() {
        return this.dbTemplate;
    }

    public PostgreCharset getEncoding() {
        return this.encoding;
    }

    public PostgreTablespace getTablespace() {
        return this.tablespace;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

