/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreInformation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreTablespace
extends PostgreInformation {
    private long oid;
    private String name;
    private long ownerId;
    private Object[] options;

    public PostgreTablespace(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        super(database);
        this.loadInfo(dbResult);
    }

    private void loadInfo(ResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"spcname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"spcowner");
        this.options = (Object[])JDBCUtils.safeGetArray((ResultSet)dbResult, (String)"spcoptions");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public long getObjectId() {
        return this.oid;
    }

    @Property(order=2)
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.getDatabase().roleCache, this.getDatabase(), this.ownerId);
    }

    @Property(order=100)
    public Object[] getOptions() {
        return this.options;
    }
}

