/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermission;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class PostgreRolePermission
extends PostgrePermission {
    private static final Log log = Log.getLog(PostgreRolePermission.class);
    private PostgrePrivilege.Kind kind;
    private String schemaName;
    private String objectName;

    public PostgreRolePermission(PostgrePermissionsOwner owner, PostgrePrivilege.Kind kind, String schemaName, String objectName, List<PostgrePrivilege> privileges) {
        super(owner, privileges);
        this.kind = kind;
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getFullObjectName();
    }

    @Override
    public PostgreObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        PostgreSchema schema = this.owner.getDatabase().getSchema(monitor, this.schemaName);
        if (schema != null) {
            return schema.getChild(monitor, this.objectName);
        }
        return null;
    }

    public PostgrePrivilege.Kind getKind() {
        return this.kind;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getFullObjectName() {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.schemaName)) + "." + (this.kind == PostgrePrivilege.Kind.FUNCTION ? this.objectName : DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.objectName));
    }

    public String toString() {
        return this.getFullObjectName();
    }

    @Override
    public int compareTo(@NotNull PostgrePermission o) {
        if (o instanceof PostgreRolePermission) {
            int res = this.schemaName.compareTo(((PostgreRolePermission)o).schemaName);
            return res != 0 ? res : this.objectName.compareTo(((PostgreRolePermission)o).objectName);
        }
        return 0;
    }
}

