/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class PostgrePermission
implements DBSObject,
Comparable<PostgrePermission> {
    public static final short NONE = 0;
    public static final short GRANTED = 1;
    public static final short WITH_GRANT_OPTION = 2;
    public static final short WITH_HIERARCHY = 4;
    protected final PostgrePermissionsOwner owner;
    private ObjectPermission[] permissions;

    public PostgrePermission(PostgrePermissionsOwner owner, List<PostgrePrivilege> privileges) {
        this.owner = owner;
        this.permissions = new ObjectPermission[privileges.size()];
        int i = 0;
        while (i < privileges.size()) {
            PostgrePrivilege privilege = privileges.get(i);
            short permission = 1;
            if (privilege.isGrantable()) {
                permission = (short)(permission | 2);
            }
            if (privilege.isWithHierarchy()) {
                permission = (short)(permission | 4);
            }
            this.permissions[i] = new ObjectPermission(privilege.getPrivilegeType(), privilege.getGrantor(), permission);
            ++i;
        }
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @Nullable
    public PostgrePermissionsOwner getParentObject() {
        return this.owner;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    public PostgrePermissionsOwner getOwner() {
        return this.owner;
    }

    public abstract PostgreObject getTargetObject(DBRProgressMonitor var1) throws DBException;

    public ObjectPermission[] getPermissions() {
        return this.permissions;
    }

    public PostgrePrivilegeType[] getPrivileges() {
        PostgrePrivilegeType[] ppt = new PostgrePrivilegeType[this.permissions.length];
        int i = 0;
        while (i < this.permissions.length) {
            ppt[i] = this.permissions[i].getPrivilegeType();
            ++i;
        }
        return ppt;
    }

    public short getPermission(PostgrePrivilegeType privilegeType) {
        int i = 0;
        while (i < this.permissions.length) {
            if (this.permissions[i].privilegeType == privilegeType) {
                return this.permissions[i].permissions;
            }
            ++i;
        }
        return 0;
    }

    public void setPermission(PostgrePrivilegeType privilegeType, boolean permit) {
        int i = 0;
        while (i < this.permissions.length) {
            if (this.permissions[i].privilegeType == privilegeType) {
                if (permit) {
                    ObjectPermission objectPermission = this.permissions[i];
                    objectPermission.permissions = (short)(objectPermission.permissions | 1);
                } else {
                    this.permissions[i].permissions = (short)0;
                }
            }
            ++i;
        }
    }

    @Property(viewable=true, editable=true, updatable=true, order=100, name="SELECT")
    public boolean hasPermissionSelect() {
        return this.getPermission(PostgrePrivilegeType.SELECT) != 0;
    }

    public void setPermissionSelect(boolean permitted) {
        this.setPermission(PostgrePrivilegeType.SELECT, permitted);
    }

    @Property(viewable=true, order=101, name="INSERT")
    public boolean hasPermissionInsert() {
        return this.getPermission(PostgrePrivilegeType.INSERT) != 0;
    }

    @Property(viewable=true, order=102, name="UPDATE")
    public boolean hasPermissionUpdate() {
        return this.getPermission(PostgrePrivilegeType.UPDATE) != 0;
    }

    @Property(viewable=true, order=103, name="DELETE")
    public boolean hasPermissionDelete() {
        return this.getPermission(PostgrePrivilegeType.DELETE) != 0;
    }

    @Property(viewable=true, order=104, name="TRUNCATE")
    public boolean hasPermissionTruncate() {
        return this.getPermission(PostgrePrivilegeType.TRUNCATE) != 0;
    }

    @Property(viewable=true, order=105, name="REFERENCES")
    public boolean hasPermissionReferences() {
        return this.getPermission(PostgrePrivilegeType.REFERENCES) != 0;
    }

    @Property(viewable=true, order=106, name="TRIGGER")
    public boolean hasPermissionTrigger() {
        return this.getPermission(PostgrePrivilegeType.TRIGGER) != 0;
    }

    public boolean hasAllPrivileges(Object object) {
        PostgrePrivilegeType[] postgrePrivilegeTypeArray = PostgrePrivilegeType.values();
        int n = postgrePrivilegeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PostgrePrivilegeType pt = postgrePrivilegeTypeArray[n2];
            if (pt.isValid() && pt.supportsType(object.getClass()) && this.getPermission(pt) == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static class ObjectPermission {
        @NotNull
        private PostgrePrivilegeType privilegeType;
        @NotNull
        private String grantor;
        private short permissions;

        public ObjectPermission(@NotNull PostgrePrivilegeType privilegeType, @NotNull String grantor, short permissions) {
            this.privilegeType = privilegeType;
            this.grantor = grantor;
            this.permissions = permissions;
        }

        @NotNull
        public PostgrePrivilegeType getPrivilegeType() {
            return this.privilegeType;
        }

        @NotNull
        public String getGrantor() {
            return this.grantor;
        }

        public short getPermissions() {
            return this.permissions;
        }

        public String toString() {
            return this.privilegeType.toString();
        }
    }
}

