/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeCache;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCPreparedStatementCachedImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class PostgreDatabase
implements DBSInstance,
DBSCatalog,
DBPRefreshableObject,
DBPStatefulObject,
DBPNamedObject2,
PostgreObject,
DBSObjectSelector {
    private static final Log log = Log.getLog(PostgreDatabase.class);
    private PostgreDataSource dataSource;
    private long oid;
    private String name;
    private long ownerId;
    private String templateName;
    private long encodingId;
    private String collate;
    private String ctype;
    private boolean isTemplate;
    private boolean allowConnect;
    private int connectionLimit;
    private long tablespaceId;
    public final RoleCache roleCache = new RoleCache();
    public final AccessMethodCache accessMethodCache = new AccessMethodCache();
    public final ForeignDataWrapperCache foreignDataWrapperCache = new ForeignDataWrapperCache();
    public final ForeignServerCache foreignServerCache = new ForeignServerCache();
    public final LanguageCache languageCache = new LanguageCache();
    public final EncodingCache encodingCache = new EncodingCache();
    public final TablespaceCache tablespaceCache = new TablespaceCache();
    public final SchemaCache schemaCache = new SchemaCache();
    public final LongKeyMap<PostgreDataType> dataTypeCache = new LongKeyMap();
    public final Map<String, JDBCPreparedStatementCachedImpl> statmentCache = new ConcurrentHashMap<String, JDBCPreparedStatementCachedImpl>();

    public PostgreDatabase(PostgreDataSource dataSource, JDBCResultSet dbResult) throws SQLException {
        this.dataSource = dataSource;
        this.loadInfo(dbResult);
    }

    private void loadInfo(JDBCResultSet dbResult) throws SQLException {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"datdba");
        this.encodingId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"encoding");
        this.collate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datcollate");
        this.ctype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datctype");
        this.isTemplate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"datistemplate");
        this.allowConnect = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"datallowconn");
        this.connectionLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"datconnlimit");
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"dattablespace");
    }

    public PostgreDatabase(PostgreDataSource dataSource, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) {
        this.dataSource = dataSource;
        this.name = name;
        this.ownerId = owner.getObjectId();
        this.templateName = templateName;
        this.tablespaceId = tablespace.getObjectId();
        this.encodingId = encoding.getObjectId();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this;
    }

    @Override
    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    @Property(order=3)
    public PostgreRole getDBA(DBRProgressMonitor monitor) throws DBException {
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.roleCache, this, this.ownerId);
    }

    @Property(order=5)
    public PostgreCharset getDefaultEncoding(DBRProgressMonitor monitor) throws DBException {
        return (PostgreCharset)PostgreUtils.getObjectById(monitor, this.encodingCache, this, this.encodingId);
    }

    @Property(order=10)
    public String getCollate() {
        return this.collate;
    }

    @Property(order=11)
    public String getCtype() {
        return this.ctype;
    }

    @Property(order=12)
    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Property(order=13)
    public boolean isAllowConnect() {
        return this.allowConnect;
    }

    @Property(order=14)
    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    @NotNull
    public JDBCExecutionContext getDefaultContext(boolean meta) {
        return this.dataSource.getDefaultContext(meta);
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return this.dataSource.getAllContexts();
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBException {
        return this.dataSource.openIsolatedContext(monitor, purpose);
    }

    public void shutdown(DBRProgressMonitor monitor) {
        for (Map.Entry<String, JDBCPreparedStatementCachedImpl> s : this.statmentCache.entrySet()) {
            try {
                s.getValue().cancel();
            }
            catch (Exception e) {
                log.error((Object)String.format("Unable to cancel statment %s error %s", s.getKey(), e.getMessage()), (Throwable)e);
            }
            try {
                s.getValue().drop();
            }
            catch (Exception e) {
                log.error((Object)String.format("Unable to close statment %s error %s", s.getKey(), e.getMessage()), (Throwable)e);
            }
        }
        this.statmentCache.clear();
    }

    @Association
    public Collection<PostgreRole> getAuthIds(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreAccessMethod> getAccessMethods(DBRProgressMonitor monitor) throws DBException {
        return this.accessMethodCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreForeignDataWrapper> getForeignDataWrappers(DBRProgressMonitor monitor) throws DBException {
        return this.foreignDataWrapperCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreForeignServer> getForeignServers(DBRProgressMonitor monitor) throws DBException {
        return this.foreignServerCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreLanguage> getLanguages(DBRProgressMonitor monitor) throws DBException {
        return this.languageCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreCharset> getEncodings(DBRProgressMonitor monitor) throws DBException {
        return this.encodingCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, this);
    }

    @Property(order=4)
    public PostgreTablespace getDefaultTablespace(DBRProgressMonitor monitor) throws DBException {
        return (PostgreTablespace)PostgreUtils.getObjectById(monitor, this.tablespaceCache, this, this.tablespaceId);
    }

    public PostgreTablespace getTablespace(DBRProgressMonitor monitor, long tablespaceId) throws DBException {
        for (PostgreTablespace ts : this.tablespaceCache.getAllObjects(monitor, this)) {
            if (ts.getObjectId() != tablespaceId) continue;
            return ts;
        }
        return null;
    }

    private void checkDefaultDatabase(DBRProgressMonitor monitor) throws DBException {
        if (this != this.dataSource.getDefaultInstance()) {
            boolean switchOnExpand = CommonUtils.toBoolean((Object)this.getDataSource().getContainer().getActualConnectionConfiguration().getProviderProperty("@dbeaver-switch-db-on-expand@"));
            if (switchOnExpand) {
                this.getDataSource().setDefaultObject(monitor, this);
            } else {
                throw new DBException("Can't access non-default database");
            }
        }
    }

    @Association
    public Collection<PostgreSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        this.checkDefaultDatabase(monitor);
        return this.schemaCache.getAllObjects(monitor, this);
    }

    @Nullable
    public PostgreSchema getCatalogSchema(DBRProgressMonitor monitor) throws DBException {
        return this.getSchema(monitor, "pg_catalog");
    }

    @Nullable
    PostgreSchema getCatalogSchema() {
        return (PostgreSchema)this.schemaCache.getCachedObject("pg_catalog");
    }

    void cacheDataTypes(DBRProgressMonitor monitor) throws DBException {
        this.dataTypeCache.clear();
        for (PostgreSchema pgSchema : this.getSchemas(monitor)) {
            pgSchema.getDataTypes(monitor);
        }
    }

    public PostgreSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        this.checkDefaultDatabase(monitor);
        return (PostgreSchema)this.schemaCache.getObject(monitor, this, name);
    }

    public PostgreSchema getSchema(DBRProgressMonitor monitor, long oid) throws DBException {
        this.checkDefaultDatabase(monitor);
        for (PostgreSchema schema : this.schemaCache.getAllObjects(monitor, this)) {
            if (schema.getObjectId() != oid) continue;
            return schema;
        }
        return null;
    }

    PostgreTableBase findTable(DBRProgressMonitor monitor, long schemaId, long tableId) throws DBException {
        PostgreSchema schema = this.getSchema(monitor, schemaId);
        if (schema == null) {
            log.error((Object)("Catalog " + schemaId + " not found"));
            return null;
        }
        return schema.getTable(monitor, tableId);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    public Class<? extends DBSObject> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return PostgreSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (this == this.dataSource.getDefaultInstance()) {
            return DBSObjectState.NORMAL;
        }
        return PostgreConstants.STATE_UNAVAILABLE;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        PostgreDatabase refDatabase = (PostgreDatabase)this.dataSource.getDatabaseCache().refreshObject(monitor, (DBSObject)this.dataSource, this);
        if (refDatabase != null && refDatabase == this.dataSource.getDefaultInstance()) {
            refDatabase.cacheDataTypes(monitor);
        }
        return refDatabase;
    }

    public Collection<PostgreRole> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, this);
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    @Nullable
    public PostgreSchema getDefaultObject() {
        return (PostgreSchema)this.schemaCache.getCachedObject(this.dataSource.getActiveSchemaName());
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        if (object instanceof PostgreSchema) {
            PostgreSchema oldActive = this.getDefaultObject();
            if (oldActive == object) {
                return;
            }
            JDBCExecutionContext[] jDBCExecutionContextArray = this.dataSource.getAllContexts();
            int n = jDBCExecutionContextArray.length;
            int n2 = 0;
            while (n2 < n) {
                JDBCExecutionContext context = jDBCExecutionContextArray[n2];
                this.setSearchPath(monitor, (PostgreSchema)object, context);
                ++n2;
            }
            this.dataSource.setActiveSchemaName(object.getName());
            this.dataSource.setSearchPath(object.getName());
            if (oldActive != null) {
                DBUtils.fireObjectSelect((DBSObject)oldActive, (boolean)false);
            }
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        return this.dataSource.refreshDefaultObject(session);
    }

    void setSearchPath(DBRProgressMonitor monitor, PostgreSchema schema, JDBCExecutionContext context) throws DBCException {
        String defSchemaName;
        ArrayList<String> newSearchPath = new ArrayList<String>(this.dataSource.getDefaultSearchPath());
        int schemaIndex = newSearchPath.indexOf(defSchemaName = schema.getName());
        if (schemaIndex != 0) {
            if (schemaIndex > 0) {
                newSearchPath.remove(schemaIndex);
            }
            newSearchPath.add(0, defSchemaName);
        }
        StringBuilder spString = new StringBuilder();
        for (String sp : newSearchPath) {
            if (spString.length() > 0) {
                spString.append(",");
            }
            spString.append(DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)sp));
        }
        try {
            Throwable sp = null;
            Iterator iterator = null;
            try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Change search path");){
                JDBCUtils.executeSQL((Connection)session, (String)("SET search_path = " + spString), (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                if (sp == null) {
                    sp = throwable;
                } else if (sp != throwable) {
                    sp.addSuppressed(throwable);
                }
                throw sp;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error setting search path", (Throwable)e, (DBPDataSource)this.dataSource);
        }
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long schemaId, long procId) throws DBException {
        PostgreSchema schema = this.getSchema(monitor, schemaId);
        if (schema != null) {
            return (PostgreProcedure)PostgreUtils.getObjectById(monitor, schema.proceduresCache, schema, procId);
        }
        return null;
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long procId) throws DBException {
        for (PostgreSchema schema : this.getSchemas(monitor)) {
            PostgreProcedure procedure = (PostgreProcedure)PostgreUtils.getObjectById(monitor, schema.proceduresCache, schema, procId);
            if (procedure == null) continue;
            return procedure;
        }
        return null;
    }

    public PostgreDataType getDataType(DBRProgressMonitor monitor, long typeId) {
        if (typeId <= 0L) {
            return null;
        }
        PostgreDataType dataType = (PostgreDataType)this.dataTypeCache.get(typeId);
        if (dataType != null) {
            return dataType;
        }
        for (PostgreSchema schema : this.getDatabase().schemaCache.getCachedObjects()) {
            dataType = schema.dataTypeCache.getDataType(typeId);
            if (dataType == null) continue;
            this.dataTypeCache.put(typeId, (Object)dataType);
            return dataType;
        }
        try {
            dataType = PostgreDataTypeCache.resolveDataType(monitor, this, typeId);
            ((PostgreSchema)dataType.getParentObject()).dataTypeCache.cacheObject(dataType);
            return dataType;
        }
        catch (Exception e) {
            log.debug((Object)("Can't resolve data type " + typeId), (Throwable)e);
            return null;
        }
    }

    public PostgreDataType getDataType(DBRProgressMonitor monitor, String typeName) {
        PostgreDataType dataType;
        PostgreSchema schema;
        if (typeName.endsWith("[]")) {
            typeName = "_" + typeName.substring(0, typeName.length() - 2);
        }
        if ((schema = this.getCatalogSchema()) != null && (dataType = (PostgreDataType)schema.dataTypeCache.getCachedObject(typeName)) != null) {
            return dataType;
        }
        List<String> searchPath = this.dataSource.getSearchPath();
        for (String schemaName : searchPath) {
            PostgreDataType dataType2;
            PostgreSchema schema2 = (PostgreSchema)this.schemaCache.getCachedObject(schemaName);
            if (schema2 == null || (dataType2 = (PostgreDataType)schema2.dataTypeCache.getCachedObject(typeName)) == null) continue;
            return dataType2;
        }
        for (PostgreSchema schema3 : this.schemaCache.getCachedObjects()) {
            PostgreDataType dataType3;
            if (searchPath.contains(schema3.getName()) || (dataType3 = (PostgreDataType)schema3.dataTypeCache.getCachedObject(typeName)) == null) continue;
            return dataType3;
        }
        try {
            dataType = PostgreDataTypeCache.resolveDataType(monitor, this, typeName);
            ((PostgreSchema)dataType.getParentObject()).dataTypeCache.cacheObject(dataType);
            return dataType;
        }
        catch (Exception e) {
            log.debug((Object)("Can't resolve data type " + typeName), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return this.name;
    }

    class AccessMethodCache
    extends JDBCObjectCache<PostgreDatabase, PostgreAccessMethod> {
        AccessMethodCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT am.oid,am.* FROM pg_catalog.pg_am am \nORDER BY am.oid");
        }

        protected PostgreAccessMethod fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreAccessMethod(owner, (ResultSet)dbResult);
        }
    }

    class EncodingCache
    extends JDBCObjectCache<PostgreDatabase, PostgreCharset> {
        EncodingCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT c.contoencoding as encid,pg_catalog.pg_encoding_to_char(c.contoencoding) as encname\nFROM pg_catalog.pg_conversion c\nGROUP BY c.contoencoding\nORDER BY 2\n");
        }

        protected PostgreCharset fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreCharset(owner, (ResultSet)dbResult);
        }
    }

    class ForeignDataWrapperCache
    extends JDBCObjectCache<PostgreDatabase, PostgreForeignDataWrapper> {
        ForeignDataWrapperCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.*,p.pronamespace as handler_schema_id \nFROM pg_catalog.pg_foreign_data_wrapper l\nLEFT OUTER JOIN pg_catalog.pg_proc p ON p.oid=l.fdwhandler \nORDER BY l.fdwname");
        }

        protected PostgreForeignDataWrapper fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreForeignDataWrapper(owner, (ResultSet)dbResult);
        }
    }

    class ForeignServerCache
    extends JDBCObjectCache<PostgreDatabase, PostgreForeignServer> {
        ForeignServerCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM pg_catalog.pg_foreign_server l\nORDER BY l.srvname");
        }

        protected PostgreForeignServer fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreForeignServer(owner, (ResultSet)dbResult);
        }
    }

    class LanguageCache
    extends JDBCObjectCache<PostgreDatabase, PostgreLanguage> {
        LanguageCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM pg_catalog.pg_language l \nORDER BY l.oid");
        }

        protected PostgreLanguage fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreLanguage(owner, (ResultSet)dbResult);
        }
    }

    class RoleCache
    extends JDBCObjectCache<PostgreDatabase, PostgreRole> {
        RoleCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT a.oid,a.* FROM pg_catalog.pg_roles a \nORDER BY a.oid");
        }

        protected PostgreRole fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRole(owner, (ResultSet)dbResult);
        }

        protected boolean handleCacheReadError(DBException error) {
            if ("42501".equals(error.getDatabaseState())) {
                log.warn((Object)error);
                this.setCache(Collections.emptyList());
                return true;
            }
            return false;
        }
    }

    static class SchemaCache
    extends JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> {
        SchemaCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreSchema object, @Nullable String objectName) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("SELECT n.oid,n.*,d.description FROM pg_catalog.pg_namespace n\nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=n.oid\n");
            DBSObjectFilter catalogFilters = database.getDataSource().getContainer().getObjectFilter(PostgreSchema.class, null, false);
            if (catalogFilters != null && !catalogFilters.isNotApplicable() || object != null || objectName != null) {
                if (object != null || objectName != null) {
                    catalogFilters = new DBSObjectFilter();
                    catalogFilters.addInclude(object != null ? object.getName() : objectName);
                } else {
                    catalogFilters = new DBSObjectFilter(catalogFilters);
                    catalogFilters.addInclude("pg_catalog");
                }
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"nspname", (boolean)true);
            }
            catalogQuery.append(" ORDER BY nspname");
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((JDBCPreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }

        protected PostgreSchema fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"nspname");
            if (name == null) {
                return null;
            }
            if (PostgreSchema.isUtilitySchema(name) && !owner.getDataSource().getContainer().isShowUtilityObjects()) {
                return null;
            }
            return new PostgreSchema(owner, name, (ResultSet)resultSet);
        }
    }

    class TablespaceCache
    extends JDBCObjectCache<PostgreDatabase, PostgreTablespace> {
        TablespaceCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT t.oid,t.* FROM pg_catalog.pg_tablespace t \nORDER BY t.oid");
        }

        protected PostgreTablespace fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreTablespace(owner, (ResultSet)dbResult);
        }
    }
}

