/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePermissionsOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedureManager
extends SQLObjectEditor<PostgreProcedure, PostgreSchema> {
    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreProcedure> getObjectsCache(PostgreProcedure object) {
        return ((PostgreSchema)object.getContainer()).proceduresCache;
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        if (CommonUtils.isEmpty((String)((PostgreProcedure)command.getObject()).getName())) {
            throw new DBException("Function name cannot be empty");
        }
    }

    protected PostgreProcedure createDatabaseObject(final DBRProgressMonitor monitor, DBECommandContext context, final PostgreSchema parent, Object copyFrom) {
        return (PostgreProcedure)new UITask<PostgreProcedure>(){

            protected PostgreProcedure runTask() {
                CreateFunctionPage editPage = new CreateFunctionPage(parent, monitor);
                if (!editPage.edit()) {
                    return null;
                }
                PostgreProcedure newProcedure = new PostgreProcedure(parent);
                newProcedure.setName(editPage.getProcedureName());
                newProcedure.setLanguage(editPage.getLanguage());
                return newProcedure;
            }
        }.execute();
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(actions, (PostgreProcedure)command.getObject());
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(actionList, (PostgreProcedure)command.getObject());
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String objectType = ((PostgreProcedure)command.getObject()).getProcedureTypeName();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop function", "DROP " + objectType + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature()));
    }

    private void createOrReplaceProcedureQuery(List<DBEPersistAction> actions, PostgreProcedure procedure) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create function", procedure.getBody(), true));
    }

    protected void addObjectExtraActions(List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<PostgreProcedure, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        boolean isDDL;
        if (command.getProperty((Object)"description") != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment function", "COMMENT ON " + ((PostgreProcedure)command.getObject()).getProcedureTypeName() + " " + ((PostgreProcedure)command.getObject()).getFullQualifiedSignature() + " IS " + SQLUtils.quoteString((DBSObject)((DBSObject)command.getObject()), (String)((PostgreProcedure)command.getObject()).getDescription())));
        }
        if (isDDL = CommonUtils.getOption(options, (String)"ddl.source")) {
            VoidProgressMonitor monitor = new VoidProgressMonitor();
            try {
                PostgreUtils.getObjectGrantPermissionActions((DBRProgressMonitor)monitor, (PostgrePermissionsOwner)command.getObject(), actions, options);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    private static class CreateFunctionPage
    extends CreateProcedurePage {
        private final PostgreSchema parent;
        private final DBRProgressMonitor monitor;
        PostgreLanguage language;

        public CreateFunctionPage(PostgreSchema parent, DBRProgressMonitor monitor) {
            super((DBSObjectContainer)parent);
            this.parent = parent;
            this.monitor = monitor;
        }

        public DBSProcedureType getPredefinedProcedureType() {
            return DBSProcedureType.FUNCTION;
        }

        protected void createExtraControls(Composite group) {
            ArrayList<PostgreLanguage> languages = new ArrayList<PostgreLanguage>();
            try {
                languages.addAll(this.parent.getDatabase().getLanguages(this.monitor));
            }
            catch (DBException e2) {
                log.error((Object)e2);
            }
            Combo languageCombo = UIUtils.createLabelCombo((Composite)group, (String)"Language", (int)12);
            for (PostgreLanguage lang : languages) {
                languageCombo.add(lang.getName());
            }
            languageCombo.addModifyListener(e -> {
                this.language = (PostgreLanguage)languages.get(languageCombo.getSelectionIndex());
            });
            languageCombo.setText("sql");
        }

        public PostgreLanguage getLanguage() {
            return this.language;
        }
    }
}

