/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndexColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreOperatorClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class PostgreIndexManager
extends SQLIndexManager<PostgreIndex, PostgreTableBase> {
    @Nullable
    public DBSObjectCache<PostgreSchema, PostgreIndex> getObjectsCache(PostgreIndex object) {
        return ((PostgreSchema)((PostgreTableBase)object.getTable()).getContainer()).indexCache;
    }

    protected PostgreIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final PostgreTableBase parent, Object from) {
        return (PostgreIndex)new UITask<PostgreIndex>(){

            protected PostgreIndex runTask() {
                EditIndexPage editPage = new EditIndexPage("Edit index", (DBSTable)parent, Collections.singletonList(DBSIndexType.OTHER));
                if (!editPage.edit()) {
                    return null;
                }
                StringBuilder idxName = new StringBuilder(64);
                idxName.append(CommonUtils.escapeIdentifier((String)parent.getName()));
                PostgreIndex index = new PostgreIndex(parent, idxName.toString(), editPage.getIndexType(), editPage.isUnique());
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    if (colIndex == 1) {
                        idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                    }
                    index.addColumn(new PostgreIndexColumn(index, (PostgreAttribute)tableColumn, null, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc")), -1L, false));
                }
                idxName.append("_IDX");
                index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
                return index;
            }
        }.execute();
    }

    protected void appendIndexColumnModifiers(StringBuilder decl, DBSTableIndexColumn indexColumn) {
        try {
            PostgreOperatorClass operatorClass = ((PostgreIndexColumn)indexColumn).getOperatorClass((DBRProgressMonitor)new VoidProgressMonitor());
            if (operatorClass != null) {
                decl.append(" ").append(operatorClass.getName());
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        if (!indexColumn.isAscending()) {
            decl.append(" DESC");
        }
    }

    protected String getDropIndexPattern(PostgreIndex index) {
        return "DROP INDEX %INDEX%";
    }

    protected void addObjectCreateActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        boolean hasDDL = false;
        PostgreIndex index = (PostgreIndex)command.getObject();
        if (index.isPersisted()) {
            try {
                String indexDDL = index.getObjectDefinitionText((DBRProgressMonitor)new VoidProgressMonitor(), DBPScriptObject.EMPTY_OPTIONS);
                if (!CommonUtils.isEmpty((String)indexDDL)) {
                    actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_index, indexDDL));
                    hasDDL = true;
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract index DDL", (Throwable)e);
            }
        }
        if (!hasDDL) {
            super.addObjectCreateActions(actions, command, options);
        }
        if (!CommonUtils.isEmpty((String)index.getDescription())) {
            PostgreIndexManager.addIndexCommentAction(actions, index);
        }
    }

    static void addIndexCommentAction(List<DBEPersistAction> actions, PostgreIndex index) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment index", "COMMENT ON INDEX " + index.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)index, (String)index.getDescription())));
    }
}

