/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.internal.ide.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.runtime.internal.ide.core.CreateLinkedResourcesRunnable;
import org.jkiss.dbeaver.runtime.internal.ide.core.IdeCoreMessages;

public class CreateLinkedFoldersRunnable
extends CreateLinkedResourcesRunnable {
    public CreateLinkedFoldersRunnable(IContainer container, java.nio.file.Path ... path) {
        super(container, 0, path);
    }

    @Override
    public String composeErrorMessage(IResource resource, java.nio.file.Path ... paths) {
        return NLS.bind((String)IdeCoreMessages.CreateLinkedFolderRunnable_e_unable_to_link, (Object)resource, (Object)paths);
    }

    @Override
    public String composeCancelMessage(IResource resource, java.nio.file.Path path) {
        return NLS.bind((String)IdeCoreMessages.CreateLinkedFolderRunnable_e_cancelled_link, (Object)resource, (Object)path);
    }

    @Override
    protected void createLink(IContainer container, java.nio.file.Path path, int flags, IProgressMonitor monitor) throws CoreException {
        String memberName;
        if (path.getFileName() == null) {
            String pathStr = path.toString().replace('\\', '/');
            while (pathStr.endsWith("/")) {
                pathStr = pathStr.substring(0, pathStr.length() - 1);
            }
            int divPos = pathStr.lastIndexOf(47);
            if (divPos >= 0) {
                pathStr = pathStr.substring(divPos + 1);
            }
            memberName = pathStr;
        } else {
            memberName = path.getFileName().toString();
        }
        Path memberPath = new Path(memberName);
        IFolder linked = container.getFolder((IPath)memberPath);
        linked.createLink(path.toUri(), 16, monitor);
    }
}

