/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.views;

import com.dbeaver.ee.mongodb.model.MGOperation;
import com.dbeaver.ee.mongodb.model.MGOperationManager;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSession;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.SinglePageDatabaseEditor;
import org.jkiss.dbeaver.ui.views.session.SessionManagerViewer;

public class MongoOperationEditor
extends SinglePageDatabaseEditor<IDatabaseEditorInput> {
    private SessionManagerViewer sessionsViewer;
    private KillSessionAction killSessionAction;
    private ShowAllConnectionsAction showAllConnectionsAction;
    private boolean showAll = false;

    public void dispose() {
        this.sessionsViewer.dispose();
        super.dispose();
    }

    public void createEditorControl(Composite parent) {
        this.killSessionAction = new KillSessionAction();
        this.showAllConnectionsAction = new ShowAllConnectionsAction();
        this.sessionsViewer = new SessionManagerViewer<MGOperation>((IWorkbenchPart)this, parent, (DBAServerSessionManager)new MGOperationManager((MongoDataSource)this.getExecutionContext().getDataSource())){

            protected void contributeToToolbar(DBAServerSessionManager sessionManager, IContributionManager contributionManager) {
                contributionManager.add((IAction)MongoOperationEditor.this.killSessionAction);
                contributionManager.add((IAction)MongoOperationEditor.this.showAllConnectionsAction);
                contributionManager.add((IContributionItem)new Separator());
            }

            protected void onSessionSelect(DBAServerSession session) {
                super.onSessionSelect(session);
                MongoOperationEditor.this.killSessionAction.setEnabled(session != null);
            }
        };
        this.sessionsViewer.refreshSessions();
    }

    public void refreshPart(Object source, boolean force) {
        this.sessionsViewer.refreshSessions();
    }

    public void setFocus() {
        if (this.sessionsViewer != null) {
            this.sessionsViewer.getControl().setFocus();
        }
    }

    private class KillSessionAction
    extends Action {
        KillSessionAction() {
            super("Kill operation", UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP"));
        }

        public void run() {
            MGOperation session = (MGOperation)MongoOperationEditor.this.sessionsViewer.getSelectedSession();
            if (session != null && UIUtils.confirmAction((Shell)MongoOperationEditor.this.getSite().getShell(), (String)this.getText(), (String)("Do you want to kill operation " + session.getId() + "?"))) {
                MongoOperationEditor.this.sessionsViewer.alterSession(MongoOperationEditor.this.sessionsViewer.getSelectedSession(), Collections.singletonMap("kill", Boolean.TRUE));
            }
        }
    }

    private class ShowAllConnectionsAction
    extends Action {
        ShowAllConnectionsAction() {
            super("Show Active/All Connections", UIUtils.getShardImageDescriptor((String)"IMG_DEF_VIEW"));
        }

        public void run() {
            MongoOperationEditor.this.showAll = !MongoOperationEditor.this.showAll;
            MongoOperationEditor.this.sessionsViewer.refreshSessions();
        }
    }
}

