/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.mongodb.MongoClient;
import java.util.Collection;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class MongoDataSourceInfo
implements DBPDataSourceInfo {
    private static final Log log = Log.getLog(MongoDataSourceInfo.class);
    private final MongoClient client;
    private String databaseVersion;

    public MongoDataSourceInfo(MongoClient client) {
        this.client = client;
    }

    public boolean isReadOnlyData() {
        return false;
    }

    public boolean isReadOnlyMetaData() {
        return false;
    }

    public String getDatabaseProductName() {
        return "MongoDB";
    }

    public String getDatabaseProductVersion() {
        if (this.databaseVersion == null) {
            try {
                Document buildInfo = this.client.getDatabase("local").runCommand((Bson)new Document("buildInfo", (Object)1));
                this.databaseVersion = (String)buildInfo.get((Object)"version");
            }
            catch (Exception e) {
                log.warn((Object)"Error getting build info", (Throwable)e);
            }
            if (this.databaseVersion == null) {
                this.databaseVersion = this.getDriverVersion();
            }
        }
        return this.databaseVersion;
    }

    public Version getDatabaseVersion() {
        return new Version(this.getDatabaseProductVersion());
    }

    public String getDriverName() {
        return "MongoDB Java Driver";
    }

    public String getDriverVersion() {
        return this.getDriverBundle().getVersion().toString();
    }

    private Bundle getDriverBundle() {
        Bundle bundle = Platform.getBundle((String)"org.mongodb.mongo-java-driver");
        if (bundle == null) {
            throw new IllegalStateException("Mongo driver bundle 'org.mongodb.mongo-java-driver' not found");
        }
        return bundle;
    }

    public String getSchemaTerm() {
        return null;
    }

    public String getProcedureTerm() {
        return null;
    }

    public String getCatalogTerm() {
        return "Database";
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsSavepoints() {
        return false;
    }

    public boolean supportsReferentialIntegrity() {
        return false;
    }

    public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsStoredCode() {
        return true;
    }

    public Collection<DBPTransactionIsolation> getSupportedTransactionsIsolation() {
        return null;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public boolean supportsResultSetLimit() {
        return false;
    }

    public boolean supportsResultSetScroll() {
        return false;
    }

    public boolean isDynamicMetadata() {
        return true;
    }

    public boolean supportsMultipleResults() {
        return false;
    }
}

