/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.model;

import com.dbeaver.ee.mongodb.model.MGDatabase;
import com.dbeaver.ee.mongodb.model.MGOperation;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.exec.DBCSession;

public class MGOperationManager
implements DBAServerSessionManager<MGOperation> {
    public static final String PROP_KILL_QUERY = "killQuery";
    private final MongoDataSource dataSource;

    public MGOperationManager(MongoDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public Collection<MGOperation> getSessions(DBCSession session, Map<String, Object> options) throws DBException {
        MGDatabase adminDB = this.dataSource.getDatabase("admin");
        if (adminDB == null) {
            throw new DBException("Admin database not found");
        }
        DB adminDbClient = adminDB.getDB();
        if (adminDbClient == null) {
            throw new DBException("Admin database object not found");
        }
        DBCollection inprogCollection = adminDbClient.getCollection("$cmd.sys.inprog");
        DBCursor cur = inprogCollection.find((DBObject)new BasicDBObject("$all", (Object)1));
        ArrayList<MGOperation> operations = new ArrayList<MGOperation>();
        if (cur.hasNext()) {
            BasicDBList inprog = (BasicDBList)cur.next().get("inprog");
            int i = 0;
            while (i < inprog.size()) {
                operations.add(new MGOperation(this.dataSource, (DBObject)inprog.get(i)));
                ++i;
            }
        }
        return operations;
    }

    public void alterSession(DBCSession session, MGOperation mongoOperation, Map<String, Object> options) throws DBException {
    }
}

