/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.exec;

import com.dbeaver.ee.mongodb.MongoUtils;
import com.dbeaver.ee.mongodb.data.MongoDocument;
import com.dbeaver.ee.mongodb.exec.MongoBaseStatement;
import com.dbeaver.ee.mongodb.exec.MongoSession;
import com.dbeaver.ee.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MongoUpdateStatement
extends MongoBaseStatement {
    private DBSAttributeBase[] keyAttributes;
    private DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public MongoUpdateStatement(MongoSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, MongoUpdateStatement.makeQuery(mongoCollection, updateAttributes, keyAttributes, rowValues));
        this.collection = mongoCollection;
        this.keyAttributes = keyAttributes;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                DBObject o = ((MongoDocument)((Object)this.rowValues[0])).getRootNode();
                this.writeResult = this.collection.getCollection().save(o, WriteConcern.MAJORITY);
                if (this.writeResult.getN() == 0) {
                    throw new DBCException("Document wasn't updated: " + this.writeResult.toString());
                }
                if (!this.writeResult.isUpdateOfExisting()) {
                    throw new DBCException("Document wasn't updated but new document was created instead (" + o.get("_id") + ") - unsupported ObjectId format");
                }
                return false;
            }
            BasicDBObject q = new BasicDBObject();
            int i = 0;
            while (i < this.keyAttributes.length) {
                q.put(this.collection.getAttributeName(this.keyAttributes[i]), MongoUtils.unwrapMongoValue(this.keyAttributes[i], this.rowValues[this.valueAttributes.length + i]));
                ++i;
            }
            BasicDBObject o = new BasicDBObject();
            int i2 = 0;
            while (i2 < this.valueAttributes.length) {
                o.put("$set", (Object)new BasicDBObject(this.collection.getAttributeName(this.valueAttributes[i2]), MongoUtils.unwrapMongoValue(this.valueAttributes[i2], this.rowValues[i2])));
                ++i2;
            }
            this.writeResult = this.collection.getCollection().update((DBObject)q, (DBObject)o, false, false);
            if (this.writeResult.getN() == 0) {
                throw new DBCException("Document wasn't updated: " + this.writeResult.toString());
            }
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" SET ");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i])).append("=").append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        if (keyAttributes.length > 0) {
            sql.append(" WHERE ");
            i = 0;
            while (i < keyAttributes.length) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(collection.getAttributeName(keyAttributes[i])).append("=").append(collection.getAttributeValue(keyAttributes[i], rowValues[keyAttributes.length + i]));
                ++i;
            }
        }
        return sql.toString();
    }
}

