/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mongodb.data;

import com.dbeaver.ee.mongodb.data.MongoMapValue;
import com.dbeaver.ee.mongodb.model.MongoDataSource;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.IOUtils;

public class MongoDocument
extends MongoMapValue
implements DBDDocument {
    private static final Log log = Log.getLog(MongoDocument.class);
    @NotNull
    private DBObject document;

    public MongoDocument(@NotNull MongoDataSource dataSource, @NotNull DBObject sourceData) {
        super(dataSource, sourceData, null);
        this.document = sourceData;
    }

    private static Map<String, Object> toMap(DBObject sourceData) {
        if (sourceData instanceof Map) {
            return (Map)sourceData;
        }
        return Collections.emptyMap();
    }

    @Override
    @NotNull
    public String getTypeName() {
        return "DBObject";
    }

    @Override
    public int getTypeID() {
        return 2;
    }

    @Override
    public DBPDataKind getDataKind() {
        return DBPDataKind.DOCUMENT;
    }

    public String toString() {
        return this.toJson();
    }

    public Object getDocumentProperty(String name) {
        Object id;
        if (name.equals("id")) {
            return this.document.get("_id");
        }
        if (name.equals("createTime") && (id = this.document.get("_id")) instanceof ObjectId) {
            return ((ObjectId)id).getDate();
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    @NotNull
    public DBObject getRootNode() {
        return this.document;
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, String encoding) throws DBException {
        String str = JSON_BUILDER.toJson((Object)this.document);
        try {
            stream.write(str.getBytes(encoding));
        }
        catch (IOException e) {
            throw new DBException("Error serializing JSON into stream", (Throwable)e);
        }
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, String encoding) throws DBException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copyStream((InputStream)stream, (OutputStream)baos, (int)10000);
            String json = new String(baos.toByteArray(), encoding);
            this.document = (DBObject)JSON.parse((String)json);
            Object docId = this.document.get("_id");
            if (docId instanceof String) {
                try {
                    this.document.put("_id", (Object)new ObjectId((String)docId));
                }
                catch (Exception e) {
                    log.error((Object)"Error converting object ID", (Throwable)e);
                }
            }
            this.updateContents(this.document);
        }
        catch (IOException e) {
            throw new DBException("Error parsing JSON", (Throwable)e);
        }
    }
}

