/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.mssql.model.MSSQLDataSource;
import org.jkiss.dbeaver.ext.mssql.model.MSSQLSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class MSSQLDatabase
implements DBSCatalog,
DBPRefreshableObject {
    private static final Log log = Log.getLog(MSSQLDatabase.class);
    private final MSSQLDataSource dataSource;
    private String catalogName;
    private String remarks;
    private List<MSSQLSchema> schemas;

    public MSSQLDatabase(MSSQLDataSource dataSource, JDBCResultSet dbResult) {
        this(dataSource, JDBCUtils.safeGetString((ResultSet)dbResult, (int)1));
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"remarks");
    }

    public MSSQLDatabase(MSSQLDataSource dataSource, String catalogName) {
        this.dataSource = dataSource;
        this.catalogName = catalogName;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.catalogName;
    }

    public boolean isPersisted() {
        return true;
    }

    public String getDescription() {
        return this.remarks;
    }

    @Association
    public Collection<MSSQLSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        if (this.schemas == null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (JDBCSession session = this.dataSource.getDefaultContext(true).openSession(monitor, DBCExecutionPurpose.UTIL, "Load schemas");){
                this.schemas = this.loadSchemas(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.schemas;
    }

    private List<MSSQLSchema> loadSchemas(JDBCSession session) throws DBException {
        Object var8_12;
        boolean showAllSchemas = this.dataSource.isShowAllSchemas();
        DBSObjectFilter schemaFilters = this.dataSource.getContainer().getObjectFilter(GenericSchema.class, (DBSObject)this, false);
        String sysSchema = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)this)) + ".sys";
        String sql = showAllSchemas ? (this.dataSource.isServerVersionAtLeast(9, 0) ? "SELECT name FROM " + DBUtils.getQuotedIdentifier((DBSObject)this) + ".sys.schemas" : "SELECT name FROM " + DBUtils.getQuotedIdentifier((DBSObject)this) + ".dbo.sysusers") : "SELECT DISTINCT s.name\nFROM " + sysSchema + ".schemas s, " + sysSchema + ".sysobjects o\n" + "WHERE s.schema_id=o.uid\n" + "ORDER BY 1";
        ArrayList<MSSQLSchema> result = new ArrayList<MSSQLSchema>();
        try {
            Throwable throwable = null;
            var8_12 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                Throwable throwable2 = null;
                Object var11_18 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                        if (name == null) continue;
                        name = name.trim();
                        if (schemaFilters != null && !schemaFilters.matches(name)) continue;
                        MSSQLSchema schema = new MSSQLSchema(this, name);
                        result.add(schema);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this.dataSource);
        }
        if (result.isEmpty()) {
            if (!showAllSchemas) {
                result.add(new MSSQLSchema(this, "dbo"));
            } else {
                log.warn((Object)"Schema read failed: empty list returned. Try generic method.");
                try {
                    Throwable e = null;
                    var8_12 = null;
                    try (JDBCResultSet dbResult = session.getMetaData().getSchemas();){
                        while (dbResult.next()) {
                            result.add(new MSSQLSchema(this, dbResult.getString("TABLE_SCHEM")));
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"Error reading schemas from database metadata", (Throwable)e);
                }
            }
        }
        return result;
    }

    public Collection<? extends DBSObject> getChildren(DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public DBSObject getChild(DBRProgressMonitor monitor, String childName) throws DBException {
        return (DBSObject)DBUtils.findObject(this.getSchemas(monitor), (String)childName);
    }

    public Class<? extends DBSObject> getChildType(DBRProgressMonitor monitor) throws DBException {
        return MSSQLSchema.class;
    }

    public void cacheStructure(DBRProgressMonitor monitor, int scope) throws DBException {
        this.getSchemas(monitor);
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.schemas = null;
        return this;
    }
}

