/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.MSSQLDatabase;
import org.jkiss.dbeaver.ext.mssql.model.MSSQLDialect;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCBasicDataTypeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.utils.CommonUtils;

public class MSSQLDataSource
extends JDBCDataSource
implements DBSObjectSelector {
    private static final Log log = Log.getLog(MSSQLDataSource.class);
    private final CatalogCache catalogCache = new CatalogCache();
    private final JDBCBasicDataTypeCache<MSSQLDataSource, JDBCDataType> dataTypeCache = new JDBCBasicDataTypeCache((DBSObject)this);
    private String activeDatabaseName;

    public MSSQLDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new MSSQLDialect());
    }

    public Object getDataSourceFeature(String featureId) {
        if ("datasource.limit-affects-dml".equals(featureId)) {
            return true;
        }
        return super.getDataSourceFeature(featureId);
    }

    public void initialize(DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        this.catalogCache.getAllObjects(monitor, (DBSObject)this);
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load mssql datasource metadata");){
            this.activeDatabaseName = this.determineCurrentDatabase(session);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected boolean isShowAllSchemas() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-show-all-schemas@"));
    }

    protected String getConnectionUserName(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserName(connectionInfo);
    }

    protected String getConnectionUserPassword(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserPassword(connectionInfo);
    }

    public DBPDataSource getDataSource() {
        return this;
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    @Association
    public Collection<MSSQLDatabase> getDatabases(DBRProgressMonitor monitor) throws DBException {
        return this.catalogCache.getAllObjects(monitor, (DBSObject)this);
    }

    public MSSQLDatabase getDatabase(DBRProgressMonitor monitor, String childName) throws DBException {
        return (MSSQLDatabase)this.catalogCache.getObject(monitor, (DBSObject)this, childName);
    }

    public Collection<? extends DBSObject> getChildren(DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases(monitor);
    }

    public DBSObject getChild(DBRProgressMonitor monitor, String childName) throws DBException {
        return this.getDatabase(monitor, childName);
    }

    public Class<? extends DBSObject> getChildType(DBRProgressMonitor monitor) throws DBException {
        return MSSQLDatabase.class;
    }

    public void cacheStructure(DBRProgressMonitor monitor, int scope) throws DBException {
        this.catalogCache.getAllObjects(monitor, (DBSObject)this);
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    public MSSQLDatabase getDefaultObject() {
        return CommonUtils.isEmpty((String)this.activeDatabaseName) ? null : (MSSQLDatabase)this.catalogCache.getCachedObject(this.activeDatabaseName);
    }

    public void setDefaultObject(DBRProgressMonitor monitor, DBSObject object) throws DBException {
        MSSQLDatabase oldSelectedEntity = this.getDefaultObject();
        if (!(object instanceof MSSQLDatabase)) {
            throw new DBException("Invalid object type: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.useDatabase(monitor, context, (MSSQLDatabase)object);
            ++n2;
        }
        this.activeDatabaseName = object.getName();
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        if (this.activeDatabaseName != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(DBCSession session) throws DBException {
        MSSQLDatabase newCatalog;
        String newCatalogName = this.determineCurrentDatabase((JDBCSession)session);
        if (!CommonUtils.equalObjects((Object)newCatalogName, (Object)this.activeDatabaseName) && (newCatalog = (MSSQLDatabase)this.catalogCache.getCachedObject(newCatalogName)) != null) {
            this.setDefaultObject(session.getProgressMonitor(), (DBSObject)newCatalog);
            return true;
        }
        return false;
    }

    private String determineCurrentDatabase(JDBCSession session) {
        try {
            return JDBCUtils.queryString((JDBCSession)session, (String)"SELECT db_name()", (Object[])new Object[0]);
        }
        catch (SQLException e) {
            log.error((Object)e);
            return null;
        }
    }

    private void useDatabase(DBRProgressMonitor monitor, JDBCExecutionContext context, MSSQLDatabase database) throws DBCException {
        if (database == null) {
            log.debug((Object)"Null current database");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active database");){
                JDBCUtils.executeSQL((Connection)session, (String)("use " + DBUtils.getQuotedIdentifier((DBSObject)database)), (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.activeDatabaseName = null;
        return super.refreshObject(monitor);
    }

    static class CatalogCache
    extends JDBCObjectCache<MSSQLDataSource, MSSQLDatabase> {
        CatalogCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MSSQLDataSource owner) throws SQLException {
            return session.prepareStatement("EXEC sp_tables '','','%',NULL");
        }

        protected MSSQLDatabase fetchObject(@NotNull JDBCSession session, @NotNull MSSQLDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new MSSQLDatabase(owner, resultSet);
        }
    }
}

