/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2DeleteUpdateRule;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLForeignKeyManager;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditForeignKeyPage;
import org.jkiss.utils.CommonUtils;

public class DB2ForeignKeyManager
extends SQLForeignKeyManager<DB2TableForeignKey, DB2Table> {
    private static final String SQL_DROP_FK = "ALTER TABLE %s DROP FOREIGN KEY %s";
    private static final String SQL_ALTER = "ALTER TABLE %s ALTER FOREIGN KEY %s";
    private static final String CONS_FK_NAME = "%s_%s_FK";
    private static final DBSForeignKeyModifyRule[] FK_RULES;

    static {
        ArrayList<DBSForeignKeyModifyRule> rules = new ArrayList<DBSForeignKeyModifyRule>(DB2DeleteUpdateRule.values().length);
        DB2DeleteUpdateRule[] dB2DeleteUpdateRuleArray = DB2DeleteUpdateRule.values();
        int n = dB2DeleteUpdateRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            DB2DeleteUpdateRule db2DeleteUpdateRule = dB2DeleteUpdateRuleArray[n2];
            rules.add(db2DeleteUpdateRule.getRule());
            ++n2;
        }
        FK_RULES = rules.toArray(new DBSForeignKeyModifyRule[0]);
    }

    public boolean canEditObject(DB2TableForeignKey object) {
        return false;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2TableForeignKey> getObjectsCache(DB2TableForeignKey object) {
        return ((DB2Table)object.getParentObject()).getSchema().getAssociationCache();
    }

    public DB2TableForeignKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final DB2Table table, Object from) {
        return (DB2TableForeignKey)((Object)new UITask<DB2TableForeignKey>(){

            protected DB2TableForeignKey runTask() {
                EditForeignKeyPage editDialog = new EditForeignKeyPage(DB2Messages.edit_db2_foreign_key_manager_dialog_title, (DBSTable)table, FK_RULES);
                if (!editDialog.edit()) {
                    return null;
                }
                DBSForeignKeyModifyRule deleteRule = editDialog.getOnDeleteRule();
                DBSForeignKeyModifyRule updateRule = editDialog.getOnUpdateRule();
                DB2TableUniqueKey ukConstraint = (DB2TableUniqueKey)editDialog.getUniqueConstraint();
                String tableName = CommonUtils.escapeIdentifier((String)table.getName());
                String targetTableName = CommonUtils.escapeIdentifier((String)editDialog.getUniqueConstraint().getParentObject().getName());
                DB2TableForeignKey foreignKey = new DB2TableForeignKey(table, ukConstraint, deleteRule, updateRule);
                String fkBaseName = String.format(DB2ForeignKeyManager.CONS_FK_NAME, tableName, targetTableName);
                String fkName = DBObjectNameCaseTransformer.transformObjectName((DBSObject)foreignKey, (String)fkBaseName);
                foreignKey.setName(fkName);
                ArrayList<DB2TableKeyColumn> columns = new ArrayList<DB2TableKeyColumn>(editDialog.getColumns().size());
                int colIndex = 1;
                for (EditForeignKeyPage.FKColumnInfo tableColumn : editDialog.getColumns()) {
                    DB2TableKeyColumn column = new DB2TableKeyColumn((AbstractTableConstraint<DB2Table>)foreignKey, (DB2TableColumn)tableColumn.getOwnColumn(), colIndex++);
                    columns.add(column);
                }
                foreignKey.setColumns(columns);
                return foreignKey;
            }
        }.execute());
    }

    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        throw new IllegalStateException("Object modification is not supported in " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public String getDropForeignKeyPattern(DB2TableForeignKey foreignKey) {
        String tableName = ((DB2Table)foreignKey.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
        return String.format(SQL_DROP_FK, tableName, foreignKey.getName());
    }
}

