/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.edit.MySQLTableManager;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLView;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class MySQLViewManager
extends MySQLTableManager {
    @Override
    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableBase> getObjectsCache(MySQLTableBase object) {
        return ((MySQLCatalog)object.getContainer()).getTableCache();
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command) throws DBException {
        MySQLTableBase object = (MySQLTableBase)command.getObject();
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((MySQLView)object).getAdditionalInfo().getDefinition())) {
            throw new DBException("View definition cannot be empty");
        }
    }

    @Override
    protected MySQLView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, MySQLCatalog parent, Object copyFrom) {
        MySQLView newView = new MySQLView(parent);
        try {
            newView.setName(this.getNewChildName(monitor, (DBSObjectContainer)parent, "new_view"));
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return newView;
    }

    @Override
    protected void addStructObjectCreateActions(List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (MySQLView)command.getObject());
    }

    @Override
    protected void addObjectModifyActions(List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actionList, (MySQLView)command.getObject());
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP VIEW " + ((MySQLTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void createOrReplaceViewQuery(List<DBEPersistAction> actions, MySQLView view) {
        StringBuilder decl = new StringBuilder(200);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        decl.append("CREATE OR REPLACE VIEW ").append(view.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(lineSeparator).append("AS ").append(view.getAdditionalInfo().getDefinition());
        MySQLView.CheckOption checkOption = view.getAdditionalInfo().getCheckOption();
        if (checkOption != null && checkOption != MySQLView.CheckOption.NONE) {
            decl.append(lineSeparator).append("WITH ").append(checkOption.getDefinitionName()).append(" CHECK OPTION");
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", decl.toString()));
    }
}

