/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDBLink;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleGrantee;
import org.jkiss.dbeaver.ext.oracle.model.OracleRecycledObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleRole;
import org.jkiss.dbeaver.ext.oracle.model.OracleSQLDialect;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleStructureAssistant;
import org.jkiss.dbeaver.ext.oracle.model.OracleSynonym;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.ext.oracle.model.OracleUserProfile;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.plan.OraclePlanAnalyser;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.ui.DBUserInterface;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class OracleDataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBCQueryPlanner,
IAdaptable {
    private static final Log log = Log.getLog(OracleDataSource.class);
    public final SchemaCache schemaCache = new SchemaCache();
    final DataTypeCache dataTypeCache = new DataTypeCache();
    final TablespaceCache tablespaceCache = new TablespaceCache();
    final UserCache userCache = new UserCache();
    final ProfileCache profileCache = new ProfileCache();
    final RoleCache roleCache = new RoleCache();
    private OracleOutputReader outputReader;
    private OracleSchema publicSchema;
    private String activeSchemaName;
    private boolean isAdmin;
    private boolean isAdminVisible;
    private String planTableName;
    private boolean useRuleHint;
    private final Map<String, Boolean> availableViews = new HashMap<String, Boolean>();
    private Pattern ERROR_POSITION_PATTERN = Pattern.compile(".+\\s+line ([0-9]+), column ([0-9]+)");

    public OracleDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new OracleSQLDialect());
        this.outputReader = new OracleOutputReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isViewAvailable(@NotNull DBRProgressMonitor monitor, @NotNull String schemaName, @NotNull String viewName) {
        Boolean available;
        viewName = viewName.toUpperCase();
        Object object = this.availableViews;
        synchronized (object) {
            available = this.availableViews.get(viewName);
        }
        if (available == null) {
            try {
                object = null;
                Object var6_8 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Check view existence");){
                    Throwable throwable = null;
                    Object var9_13 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT 1 FROM " + DBUtils.getQuotedIdentifier((DBPDataSource)this, (String)schemaName) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)this, (String)viewName));){
                        dbStat.setFetchSize(1);
                        Throwable throwable2 = null;
                        Object var12_18 = null;
                        try (JDBCResultSet dbResults = dbStat.executeQuery();){
                            available = dbResults.next();
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (SQLException e) {
                available = false;
            }
            object = this.availableViews;
            synchronized (object) {
                this.availableViews.put(viewName, available);
            }
        }
        return available;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @NotNull String purpose) throws DBCException {
        try {
            Connection connection = super.openConnection(monitor, purpose);
            return connection;
        }
        catch (DBCException e) {
            if (e.getErrorCode() == 28001 && this.changeExpiredPassword(monitor)) {
                return this.openConnection(monitor, purpose);
            }
            throw e;
        }
    }

    private boolean changeExpiredPassword(DBRProgressMonitor monitor) {
        DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
        DBAPasswordChangeInfo passwordInfo = DBUserInterface.getInstance().promptUserPasswordChange("Password has expired. Set new password.", connectionInfo.getUserName(), connectionInfo.getUserPassword());
        if (passwordInfo == null) {
            return false;
        }
        try {
            if (passwordInfo.getNewPassword() == null) {
                throw new DBException("You can't set empty password");
            }
            Properties connectProps = this.getAllConnectionProperties(monitor, connectionInfo);
            connectProps.setProperty("oracle.jdbc.newPassword", passwordInfo.getNewPassword());
            String url = this.getConnectionURL(connectionInfo);
            monitor.subTask("Connecting for expired password change");
            Driver driverInstance = this.getDriverInstance(monitor);
            Throwable throwable = null;
            Object var8_10 = null;
            try (Connection connection = driverInstance.connect(url, connectProps);){
                if (connection == null) {
                    throw new DBCException("Null connection returned");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            connectionInfo.setUserPassword(passwordInfo.getNewPassword());
            this.getContainer().getConnectionConfiguration().setUserPassword(passwordInfo.getNewPassword());
            this.getContainer().getRegistry().flushConfig();
            return true;
        }
        catch (Exception e) {
            DBUserInterface.getInstance().showError("Error changing password", "Error changing expired password", (Throwable)e);
            return false;
        }
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        if (this.outputReader == null) {
            this.outputReader = new OracleOutputReader();
        }
        this.outputReader.enableServerOutput(monitor, (DBCExecutionContext)context, this.outputReader.isServerOutputEnabled());
        if (setActiveObject) {
            this.setCurrentSchema(monitor, context, this.getDefaultObject());
        }
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        Throwable throwable = null;
        Object var6_7 = null;
        try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.META, "Set connection parameters");){
            String nlsDateFormat;
            String sessionTerritory;
            String sessionLanguage = connectionInfo.getProviderProperty("@dbeaver-session-language@");
            if (sessionLanguage != null) {
                try {
                    JDBCUtils.executeSQL((Connection)session, (String)("ALTER SESSION SET NLS_LANGUAGE='" + sessionLanguage + "'"), (Object[])new Object[0]);
                }
                catch (SQLException e) {
                    log.warn((Object)"Can't set session language", (Throwable)e);
                }
            }
            if ((sessionTerritory = connectionInfo.getProviderProperty("@dbeaver-session-territory@")) != null) {
                try {
                    JDBCUtils.executeSQL((Connection)session, (String)("ALTER SESSION SET NLS_TERRITORY='" + sessionTerritory + "'"), (Object[])new Object[0]);
                }
                catch (SQLException e) {
                    log.warn((Object)"Can't set session territory", (Throwable)e);
                }
            }
            if ((nlsDateFormat = connectionInfo.getProviderProperty("@dbeaver-session-nls-date-format@")) != null) {
                try {
                    JDBCUtils.executeSQL((Connection)session, (String)("ALTER SESSION SET NLS_DATE_FORMAT='" + nlsDateFormat + "'"), (Object[])new Object[0]);
                }
                catch (SQLException e) {
                    log.warn((Object)"Can't set session NLS date format", (Throwable)e);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String getConnectionUserName(@NotNull DBPConnectionConfiguration connectionInfo) {
        String role = connectionInfo.getProviderProperty("@dbeaver-internal-logon@");
        return role == null ? connectionInfo.getUserName() : String.valueOf(connectionInfo.getUserName()) + " AS " + role;
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        return new JDBCDataSourceInfo(metaData);
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        Throwable rootCause = GeneralUtils.getRootCause((Throwable)error);
        if (rootCause instanceof SQLException && ((SQLException)rootCause).getErrorCode() == 17023) {
            return DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED;
        }
        return super.discoverErrorType(error);
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> connectionsProps = new HashMap<String, String>();
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            connectionsProps.put("v$session.program", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose), (int)48));
        }
        if (CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-os-authentication@"))) {
            connectionsProps.put("v$session.osuser", System.getProperty("user.name"));
        }
        return connectionsProps;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isAdminVisible() {
        return this.isAdmin || this.isAdminVisible;
    }

    public boolean isUseRuleHint() {
        return this.useRuleHint;
    }

    @Association
    public Collection<OracleSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public OracleSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        if (this.publicSchema != null && this.publicSchema.getName().equals(name)) {
            return this.publicSchema;
        }
        return (OracleSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<OracleTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<OracleUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public OracleUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<OracleUserProfile> getProfiles(DBRProgressMonitor monitor) throws DBException {
        return this.profileCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<OracleRole> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public OracleGrantee getGrantee(DBRProgressMonitor monitor, String name) throws DBException {
        OracleUser user = (OracleUser)this.userCache.getObject(monitor, (DBSObject)this, name);
        if (user != null) {
            return user;
        }
        return (OracleGrantee)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<OracleSynonym> getPublicSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getSynonyms(monitor);
    }

    @Association
    public Collection<OracleDBLink> getPublicDatabaseLinks(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getDatabaseLinks(monitor);
    }

    @Association
    public Collection<OracleRecycledObject> getUserRecycledObjects(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getRecycledObjects(monitor);
    }

    public boolean isAtLeastV9() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 9;
    }

    public boolean isAtLeastV10() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 10;
    }

    public boolean isAtLeastV11() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 11;
    }

    public boolean isAtLeastV12() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 12;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        Object useRuleHintProp = connectionInfo.getProviderProperty("@dbeaver-use-rule-hint@");
        if (useRuleHintProp != null) {
            this.useRuleHint = CommonUtils.getBoolean((String)useRuleHintProp, (boolean)false);
        }
        this.publicSchema = new OracleSchema(this, 1L, "PUBLIC");
        try {
            useRuleHintProp = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                String showAdmin;
                this.isAdminVisible = this.isAdmin = "YES".equals(JDBCUtils.queryString((JDBCSession)session, (String)"SELECT 'YES' FROM USER_ROLE_PRIVS WHERE GRANTED_ROLE='DBA'", (Object[])new Object[0]));
                if (!this.isAdminVisible && (showAdmin = connectionInfo.getProviderProperty("@dbeaver-always-show-dba@")) != null) {
                    this.isAdminVisible = CommonUtils.getBoolean((String)showAdmin, (boolean)false);
                }
                this.activeSchemaName = OracleUtils.getCurrentSchema(session);
                if (this.activeSchemaName != null && this.activeSchemaName.isEmpty()) {
                    this.activeSchemaName = null;
                }
            }
            catch (Throwable throwable) {
                if (useRuleHintProp == null) {
                    useRuleHintProp = throwable;
                } else if (useRuleHintProp != throwable) {
                    ((Throwable)useRuleHintProp).addSuppressed(throwable);
                }
                throw useRuleHintProp;
            }
        }
        catch (SQLException e) {
            log.warn((Object)e);
        }
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.schemaCache.clearCache();
        this.dataTypeCache.clearCache();
        this.tablespaceCache.clearCache();
        this.userCache.clearCache();
        this.profileCache.clearCache();
        this.roleCache.clearCache();
        this.activeSchemaName = null;
        this.initialize(monitor);
        return this;
    }

    public Collection<OracleSchema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public OracleSchema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    public Class<? extends OracleSchema> getChildType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return OracleSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    @Nullable
    public OracleSchema getDefaultObject() {
        return this.activeSchemaName == null ? null : (OracleSchema)this.schemaCache.getCachedObject(this.activeSchemaName);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        OracleSchema oldSelectedEntity = this.getDefaultObject();
        if (!(object instanceof OracleSchema)) {
            throw new IllegalArgumentException("Invalid object type: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.setCurrentSchema(monitor, context, (OracleSchema)object);
            ++n2;
        }
        this.activeSchemaName = object.getName();
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        if (this.activeSchemaName != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        try {
            OracleSchema newSchema;
            String currentSchema = OracleUtils.getCurrentSchema((JDBCSession)session);
            if (currentSchema != null && !CommonUtils.equalObjects((Object)currentSchema, (Object)this.activeSchemaName) && (newSchema = (OracleSchema)this.schemaCache.getCachedObject(currentSchema)) != null) {
                this.setDefaultObject(session.getProgressMonitor(), newSchema);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this);
        }
    }

    private void setCurrentSchema(DBRProgressMonitor monitor, JDBCExecutionContext executionContext, OracleSchema object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active schema");){
                OracleUtils.setCurrentSchema(session, object.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query) throws DBException {
        OraclePlanAnalyser plan = new OraclePlanAnalyser(this, (JDBCSession)session, query);
        plan.explain();
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    @Nullable
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new OracleStructureAssistant(this));
        }
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast(this.outputReader);
        }
        return (T)super.getAdapter(adapter);
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        if (typeName.equals("XMLTYPE") || typeName.equals("SYS.XMLTYPE")) {
            return DBPDataKind.CONTENT;
        }
        DBPDataKind dataKind = OracleDataType.getDataKind(typeName);
        if (dataKind != null) {
            return dataKind;
        }
        return super.resolveDataKind(typeName, valueType);
    }

    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public DBSDataType getLocalDataType(String typeName) {
        return (DBSDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        int divPos = typeFullName.indexOf(46);
        if (divPos == -1) {
            return this.getLocalDataType(typeFullName);
        }
        String schemaName = typeFullName.substring(0, divPos);
        String typeName = typeFullName.substring(divPos + 1);
        OracleSchema schema = this.getSchema(monitor, schemaName);
        if (schema == null) {
            return null;
        }
        return schema.getDataType(monitor, typeName);
    }

    @Nullable
    public String getPlanTableName(JDBCSession session) throws DBException {
        if (this.planTableName == null) {
            String tableName = this.getContainer().getPreferenceStore().getString("oracle.explain.table");
            String[] candidateNames = !CommonUtils.isEmpty((String)tableName) ? new String[]{tableName} : new String[]{"PLAN_TABLE", "TOAD_PLAN_TABLE"};
            String[] stringArray = candidateNames;
            int n = candidateNames.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    String candidate = stringArray[n2];
                    try {
                        JDBCUtils.executeSQL((Connection)session, (String)("SELECT 1 FROM " + candidate), (Object[])new Object[0]);
                    }
                    catch (SQLException e) {
                        break block6;
                    }
                    this.planTableName = candidate;
                    break;
                }
                ++n2;
            }
            if (this.planTableName == null) {
                String newPlanTableName = candidateNames[0];
                if (!UIUtils.confirmAction((String)"Oracle PLAN_TABLE missing", (String)("PLAN_TABLE not found in current user's session. Do you want DBeaver to create new PLAN_TABLE (" + newPlanTableName + ")?"))) {
                    return null;
                }
                this.planTableName = this.createPlanTable(session, newPlanTableName);
            }
        }
        return this.planTableName;
    }

    private String createPlanTable(JDBCSession session, String tableName) throws DBException {
        try {
            JDBCUtils.executeSQL((Connection)session, (String)"create global temporary table ${TABLE_NAME} (\nstatement_id varchar2(30),\nplan_id number,\ntimestamp date,\nremarks varchar2(4000),\noperation varchar2(30),\noptions varchar2(255),\nobject_node varchar2(128),\nobject_owner varchar2(30),\nobject_name varchar2(30),\nobject_alias varchar2(65),\nobject_instance numeric,\nobject_type varchar2(30),\noptimizer varchar2(255),\nsearch_columns number,\nid numeric,\nparent_id numeric,\ndepth numeric,\nposition numeric,\ncost numeric,\ncardinality numeric,\nbytes numeric,\nother_tag varchar2(255),\npartition_start varchar2(255),\npartition_stop varchar2(255),\npartition_id numeric,\nother long,\ndistribution varchar2(30),\ncpu_cost numeric,\nio_cost numeric,\ntemp_space numeric,\naccess_predicates varchar2(4000),\nfilter_predicates varchar2(4000),\nprojection varchar2(4000),\ntime numeric,\nqblock_name varchar2(30),\nother_xml clob\n) on commit preserve rows".replace("${TABLE_NAME}", tableName), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            throw new DBException("Error creating PLAN table", (Throwable)e, (DBPDataSource)this);
        }
        return tableName;
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        return super.createQueryTransformer(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        while (error instanceof DBException) {
            if (error.getCause() == null) break;
            error = error.getCause();
        }
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message)) {
            Matcher matcher = this.ERROR_POSITION_PATTERN.matcher(message);
            ArrayList<DBPErrorAssistant.ErrorPosition> positions = new ArrayList<DBPErrorAssistant.ErrorPosition>();
            while (matcher.find()) {
                DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                pos.info = matcher.group(1);
                pos.line = Integer.parseInt(matcher.group(1)) - 1;
                pos.position = Integer.parseInt(matcher.group(2)) - 1;
                positions.add(pos);
            }
            if (!positions.isEmpty()) {
                return positions.toArray(new DBPErrorAssistant.ErrorPosition[positions.size()]);
            }
        }
        if (error.getCause() != null) {
            try {
                Object errorPosition = BeanUtils.readObjectProperty((Object)error.getCause(), (String)"errorPosition");
                if (errorPosition instanceof Number) {
                    DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                    pos.position = ((Number)errorPosition).intValue();
                    return new DBPErrorAssistant.ErrorPosition[]{pos};
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(error instanceof SQLException) || !SQLState.SQL_42000.getCode().equals(((SQLException)error).getSQLState())) return null;
        Throwable throwable = null;
        Object var7_9 = null;
        try {
            JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Extract last error position");
            try {
                DBPErrorAssistant.ErrorPosition[] errorPositionArray;
                JDBCCallableStatement stat;
                Throwable throwable2;
                block30: {
                    int errorPos;
                    block28: {
                        block29: {
                            throwable2 = null;
                            Object var10_15 = null;
                            stat = session.prepareCall("declare\n  l_cursor integer default dbms_sql.open_cursor; \nbegin \n  begin \n  dbms_sql.parse(  l_cursor, ?, dbms_sql.native ); \n    exception \n      when others then ? := dbms_sql.last_error_position; \n    end; \n    dbms_sql.close_cursor( l_cursor );\nend;");
                            stat.setString(1, query);
                            stat.registerOutParameter(2, 4);
                            stat.execute();
                            errorPos = stat.getInt(2);
                            if (errorPos > 0) break block28;
                            if (stat == null) break block29;
                            stat.close();
                        }
                        if (session == null) return null;
                        session.close();
                        return null;
                    }
                    DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                    pos.position = errorPos;
                    DBPErrorAssistant.ErrorPosition[] errorPositionArray2 = new DBPErrorAssistant.ErrorPosition[1];
                    errorPositionArray = errorPositionArray2;
                    errorPositionArray2[0] = pos;
                    if (stat == null) break block30;
                    stat.close();
                }
                try {
                    if (session == null) return errorPositionArray;
                    session.close();
                    return errorPositionArray;
                }
                catch (Throwable throwable3) {
                    try {
                        if (stat == null) throw throwable3;
                        stat.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        catch (SQLException e) {
                            log.debug((Object)("Can't extract parse error info: " + e.getMessage()));
                            if (session == null) return null;
                            session.close();
                        }
                    }
                }
                return null;
            }
            catch (Throwable throwable5) {
                if (session == null) throw throwable5;
                session.close();
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            } else {
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    static class DataTypeCache
    extends JDBCObjectCache<OracleDataSource, OracleDataType> {
        DataTypeCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner.getDataSource()) + " * FROM SYS.ALL_TYPES WHERE OWNER IS NULL ORDER BY TYPE_NAME");
        }

        protected OracleDataType fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataType((DBSObject)owner, (ResultSet)resultSet);
        }

        protected void invalidateObjects(DBRProgressMonitor monitor, OracleDataSource owner, Iterator<OracleDataType> objectIter) {
            for (Map.Entry<String, OracleDataType.TypeDesc> predefinedType : OracleDataType.PREDEFINED_TYPES.entrySet()) {
                if (this.getCachedObject(predefinedType.getKey()) != null) continue;
                this.cacheObject(new OracleDataType((DBSObject)owner, predefinedType.getKey(), true));
            }
        }
    }

    private class OracleOutputReader
    implements DBCServerOutputReader {
        private OracleOutputReader() {
        }

        public boolean isServerOutputEnabled() {
            return OracleDataSource.this.getContainer().getPreferenceStore().getBoolean("oracle.dbms.output");
        }

        public boolean isAsyncOutputReadSupported() {
            return false;
        }

        public void enableServerOutput(DBRProgressMonitor monitor, DBCExecutionContext context, boolean enable) throws DBCException {
            String sql = enable ? "BEGIN DBMS_OUTPUT.ENABLE(1000000); END;" : "BEGIN DBMS_OUTPUT.DISABLE; END;";
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, String.valueOf(enable ? "Enable" : "Disable ") + "DBMS output");){
                    JDBCUtils.executeSQL((Connection)((JDBCSession)session), (String)sql, (Object[])new Object[0]);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException(e, (DBPDataSource)OracleDataSource.this);
            }
        }

        public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @Nullable SQLQueryResult queryResult, @Nullable DBCStatement statement, @NotNull PrintWriter output) throws DBCException {
            Throwable throwable = null;
            Object var7_8 = null;
            try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Read DBMS output");){
                try {
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (CallableStatement getLineProc = session.getOriginal().prepareCall("{CALL DBMS_OUTPUT.GET_LINE(?, ?)}");){
                        getLineProc.registerOutParameter(1, 12);
                        getLineProc.registerOutParameter(2, 4);
                        int status = 0;
                        while (status == 0) {
                            getLineProc.execute();
                            status = getLineProc.getInt(2);
                            if (status != 0) continue;
                            String str = getLineProc.getString(1);
                            if (str != null) {
                                output.write(str);
                            }
                            output.write(10);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException(e, (DBPDataSource)OracleDataSource.this);
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
    }

    static class ProfileCache
    extends JDBCStructCache<OracleDataSource, OracleUserProfile, OracleUserProfile.ProfileResource> {
        protected ProfileCache() {
            super((Object)"PROFILE");
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT DISTINCT PROFILE FROM DBA_PROFILES ORDER BY PROFILE");
        }

        protected OracleUserProfile fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleUserProfile(owner, (ResultSet)resultSet);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull OracleDataSource dataSource, @Nullable OracleUserProfile forObject) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RESOURCE_NAME,RESOURCE_TYPE,LIMIT FROM DBA_PROFILES " + (forObject == null ? "" : "WHERE PROFILE=? ") + "ORDER BY RESOURCE_NAME");
            if (forObject != null) {
                dbStat.setString(1, forObject.getName());
            }
            return dbStat;
        }

        protected OracleUserProfile.ProfileResource fetchChild(@NotNull JDBCSession session, @NotNull OracleDataSource dataSource, @NotNull OracleUserProfile parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleUserProfile.ProfileResource(parent, (ResultSet)dbResult);
        }
    }

    static class RoleCache
    extends JDBCObjectCache<OracleDataSource, OracleRole> {
        RoleCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM DBA_ROLES ORDER BY ROLE");
        }

        protected OracleRole fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleRole(owner, (ResultSet)resultSet);
        }
    }

    static class SchemaCache
    extends JDBCObjectCache<OracleDataSource, OracleSchema> {
        SchemaCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            StringBuilder schemasQuery = new StringBuilder();
            boolean manyObjects = "false".equals(owner.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-check-schema-content@"));
            schemasQuery.append("SELECT U.* FROM SYS.ALL_USERS U\n");
            schemasQuery.append("WHERE (");
            if (manyObjects) {
                schemasQuery.append("U.USERNAME IS NOT NULL");
            } else {
                schemasQuery.append("U.USERNAME IN (SELECT DISTINCT OWNER FROM SYS.ALL_OBJECTS)");
            }
            DBSObjectFilter schemaFilters = owner.getContainer().getObjectFilter(OracleSchema.class, null, false);
            if (schemaFilters != null) {
                JDBCUtils.appendFilterClause((StringBuilder)schemasQuery, (DBSObjectFilter)schemaFilters, (String)"U.USERNAME", (boolean)false);
            }
            schemasQuery.append(")");
            JDBCPreparedStatement dbStat = session.prepareStatement(schemasQuery.toString());
            if (schemaFilters != null) {
                JDBCUtils.setFilterParameters((JDBCPreparedStatement)dbStat, (int)1, (DBSObjectFilter)schemaFilters);
            }
            return dbStat;
        }

        protected OracleSchema fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSchema(owner, (ResultSet)resultSet);
        }

        protected void invalidateObjects(DBRProgressMonitor monitor, OracleDataSource owner, Iterator<OracleSchema> objectIter) {
            this.setListOrderComparator(DBUtils.nameComparator());
            if (!CommonUtils.isEmpty((String)owner.activeSchemaName) && this.getCachedObject(owner.activeSchemaName) == null) {
                this.cacheObject(new OracleSchema(owner, 100L, owner.activeSchemaName));
            }
        }
    }

    static class TablespaceCache
    extends JDBCObjectCache<OracleDataSource, OracleTablespace> {
        TablespaceCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM " + OracleUtils.getSysUserViewName(session.getProgressMonitor(), owner, "TABLESPACES") + " ORDER BY TABLESPACE_NAME");
        }

        protected OracleTablespace fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleTablespace(owner, (ResultSet)resultSet);
        }
    }

    static class UserCache
    extends JDBCObjectCache<OracleDataSource, OracleUser> {
        UserCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner, "USERS") + " ORDER BY USERNAME");
        }

        protected OracleUser fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleUser(owner, (ResultSet)resultSet);
        }
    }
}

