/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.internal.ide.core;

import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.jkiss.dbeaver.runtime.ide.core.DBeaverIDECore;

public abstract class CreateLinkedResourcesRunnable
implements ICoreRunnable {
    private final IContainer container;
    private final Path[] paths;
    private final int flags;

    public CreateLinkedResourcesRunnable(IContainer container, int flags, Path ... paths) {
        this.container = container;
        this.flags = flags;
        this.paths = paths;
    }

    public abstract String composeErrorMessage(IResource var1, Path ... var2);

    public abstract String composeCancelMessage(IResource var1, Path var2);

    public void run(IProgressMonitor monitor) throws CoreException {
        if (this.container == null) {
            String message = this.composeErrorMessage((IResource)this.container, this.paths);
            IStatus error = DBeaverIDECore.createError(message);
            throw new CoreException(error);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.paths.length);
        Path[] pathArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            Path path = pathArray[n2];
            if (subMonitor.isCanceled()) {
                String message = this.composeCancelMessage((IResource)this.container, path);
                IStatus cancel = DBeaverIDECore.createCancel(message);
                throw new CoreException(cancel);
            }
            if (path == null) {
                String message = this.composeErrorMessage((IResource)this.container, path);
                IStatus error = DBeaverIDECore.createError(message);
                throw new CoreException(error);
            }
            this.createLink(this.container, path, this.flags, monitor);
            subMonitor.worked(1);
            ++n2;
        }
    }

    protected abstract void createLink(IContainer var1, Path var2, int var3, IProgressMonitor var4) throws CoreException;
}

