/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;

public class PingJob
extends AbstractJob {
    private static final Log log = Log.getLog(PingJob.class);
    private final DBPDataSource dataSource;

    public PingJob(DBPDataSource dataSource) {
        super("Connection ping");
        this.setUser(false);
        this.setSystem(true);
        this.dataSource = dataSource;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        DBCExecutionContext[] dBCExecutionContextArray = this.dataSource.getAllContexts();
        int n = dBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                DBCExecutionContext context = dBCExecutionContextArray[n2];
                try {
                    context.checkContextAlive(monitor);
                }
                catch (Exception e) {
                    log.debug("Context [" + this.dataSource.getName() + "::" + context.getContextName() + "] check failed: " + e.getMessage());
                    if (!(e instanceof DBException)) break block3;
                    List<InvalidateJob.ContextInvalidateResult> results = InvalidateJob.invalidateDataSource(monitor, this.dataSource, false);
                    log.debug("Connection invalidated: " + results);
                }
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }
}

